/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.connection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageProducer;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TopicSession;
import org.springframework.jms.connection.CachedMessageProducer;
import org.springframework.jms.connection.SingleConnectionFactory;
import org.springframework.util.Assert;

public class CachingConnectionFactory
extends SingleConnectionFactory {
    private int sessionCacheSize = 1;
    private boolean cacheProducers = true;
    private final Map cachedSessions = new HashMap();

    public CachingConnectionFactory() {
        this.setReconnectOnException(true);
    }

    public void setSessionCacheSize(int sessionCacheSize) {
        Assert.isTrue(sessionCacheSize >= 1, "Session cache size must be 1 or higher");
        this.sessionCacheSize = sessionCacheSize;
    }

    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    public void setCacheProducers(boolean cacheProducers) {
        this.cacheProducers = cacheProducers;
    }

    public boolean isCacheProducers() {
        return this.cacheProducers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Map map = this.cachedSessions;
        synchronized (map) {
            this.cachedSessions.clear();
        }
        super.resetConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session getSession(Connection con, Integer mode) throws JMSException {
        LinkedList sessionList = null;
        Map map = this.cachedSessions;
        synchronized (map) {
            sessionList = (LinkedList)this.cachedSessions.get(mode);
            if (sessionList == null) {
                sessionList = new LinkedList();
                this.cachedSessions.put(mode, sessionList);
            }
        }
        Session session = null;
        LinkedList linkedList = sessionList;
        synchronized (linkedList) {
            if (!sessionList.isEmpty()) {
                session = (Session)sessionList.removeFirst();
            }
        }
        if (session != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found cached Session for mode " + mode + ": " + session));
            }
        } else {
            boolean transacted = mode == 0;
            int ackMode = transacted ? 1 : mode;
            Session targetSession = con.createSession(transacted, ackMode);
            session = this.getCachedSessionProxy(targetSession, sessionList);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created cached Session for mode " + mode + ": " + session));
            }
        }
        return session;
    }

    protected Session getCachedSessionProxy(Session target, LinkedList sessionList) {
        ArrayList<Class> classes = new ArrayList<Class>(3);
        classes.add(Session.class);
        if (target instanceof QueueSession) {
            classes.add(QueueSession.class);
        }
        if (target instanceof TopicSession) {
            classes.add(TopicSession.class);
        }
        return (Session)Proxy.newProxyInstance(Session.class.getClassLoader(), classes.toArray(new Class[classes.size()]), (InvocationHandler)new CachedSessionInvocationHandler(target, sessionList));
    }

    private class CachedSessionInvocationHandler
    implements InvocationHandler {
        private final Session target;
        private final LinkedList sessionList;
        private final Map cachedProducers = new HashMap();

        public CachedSessionInvocationHandler(Session target, LinkedList sessionList) {
            this.target = target;
            this.sessionList = sessionList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (method.getName().equals("hashCode")) {
                return new Integer(System.identityHashCode(proxy));
            }
            if (method.getName().equals("close")) {
                LinkedList linkedList = this.sessionList;
                synchronized (linkedList) {
                    if (this.sessionList.size() < CachingConnectionFactory.this.getSessionCacheSize()) {
                        if (!this.sessionList.contains(proxy)) {
                            this.sessionList.addLast(proxy);
                            if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                                CachingConnectionFactory.this.logger.debug((Object)("Returned cached Session: " + proxy));
                            }
                        }
                        return null;
                    }
                    Iterator it = this.cachedProducers.values().iterator();
                    while (it.hasNext()) {
                        ((MessageProducer)it.next()).close();
                    }
                    this.target.close();
                    if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingConnectionFactory.this.logger.debug((Object)("Closed cached Session: " + proxy));
                    }
                    return null;
                }
            }
            if ((method.getName().equals("createProducer") || method.getName().equals("createSender") || method.getName().equals("createPublisher")) && CachingConnectionFactory.this.isCacheProducers()) {
                Destination dest = (Destination)args[0];
                MessageProducer producer = (MessageProducer)this.cachedProducers.get(dest);
                if (producer != null) {
                    if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingConnectionFactory.this.logger.debug((Object)("Found cached MessageProducer for destination [" + dest + "]: " + producer));
                    }
                } else {
                    producer = this.target.createProducer(dest);
                    this.cachedProducers.put(dest, producer);
                    if (CachingConnectionFactory.this.logger.isDebugEnabled()) {
                        CachingConnectionFactory.this.logger.debug((Object)("Created cached MessageProducer for destination [" + dest + "]: " + producer));
                    }
                }
                return new CachedMessageProducer(producer);
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

