/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.namedparam.BeanPropertySqlParameterSource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class SqlParameterSourceUtils {
    public static SqlParameterSource[] createBatch(Map[] valueMaps) {
        SqlParameterSource[] batch = new MapSqlParameterSource[valueMaps.length];
        int i = 0;
        while (i < valueMaps.length) {
            Map valueMap = valueMaps[i];
            batch[i] = new MapSqlParameterSource(valueMap);
            ++i;
        }
        return batch;
    }

    public static SqlParameterSource[] createBatch(Object[] beans) {
        SqlParameterSource[] batch = new BeanPropertySqlParameterSource[beans.length];
        int i = 0;
        while (i < beans.length) {
            Object bean = beans[i];
            batch[i] = new BeanPropertySqlParameterSource(bean);
            ++i;
        }
        return batch;
    }

    public static Object getTypedValue(SqlParameterSource source, String parameterName) {
        int sqlType = source.getSqlType(parameterName);
        if (sqlType != Integer.MIN_VALUE) {
            if (source.getTypeName(parameterName) != null) {
                return new SqlParameterValue(sqlType, source.getTypeName(parameterName), source.getValue(parameterName));
            }
            return new SqlParameterValue(sqlType, source.getValue(parameterName));
        }
        return source.getValue(parameterName);
    }

    public static Map extractCaseInsensitiveParameterNames(SqlParameterSource parameterSource) {
        HashMap<String, String> caseInsensitiveParameterNames;
        block3: {
            block2: {
                caseInsensitiveParameterNames = new HashMap<String, String>();
                if (!(parameterSource instanceof BeanPropertySqlParameterSource)) break block2;
                String[] propertyNames = ((BeanPropertySqlParameterSource)parameterSource).getReadablePropertyNames();
                int i = 0;
                while (i < propertyNames.length) {
                    String name = propertyNames[i];
                    caseInsensitiveParameterNames.put(name.toLowerCase(), name);
                    ++i;
                }
                break block3;
            }
            if (!(parameterSource instanceof MapSqlParameterSource)) break block3;
            for (String name : ((MapSqlParameterSource)parameterSource).getValues().keySet()) {
                caseInsensitiveParameterNames.put(name.toLowerCase(), name);
            }
        }
        return caseInsensitiveParameterNames;
    }
}

