/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanCurrentlyInCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.CglibSubclassingInstantiationStrategy;
import org.springframework.beans.factory.support.ConstructorResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractAutowireCapableBeanFactory
extends AbstractBeanFactory
implements AutowireCapableBeanFactory {
    private InstantiationStrategy instantiationStrategy = new CglibSubclassingInstantiationStrategy();
    private boolean allowCircularReferences = true;
    private boolean allowRawInjectionDespiteWrapping = false;
    private final Set ignoredDependencyTypes = new HashSet();
    private final Set ignoredDependencyInterfaces = new HashSet();
    private final Map factoryBeanInstanceCache = CollectionFactory.createConcurrentMapIfPossible(16);
    private final Map filteredPropertyDescriptorsCache = new HashMap();
    static /* synthetic */ Class class$org$springframework$core$PriorityOrdered;

    public AbstractAutowireCapableBeanFactory() {
        this.ignoreDependencyInterface(BeanNameAware.class);
        this.ignoreDependencyInterface(BeanFactoryAware.class);
        this.ignoreDependencyInterface(BeanClassLoaderAware.class);
    }

    public AbstractAutowireCapableBeanFactory(BeanFactory parentBeanFactory) {
        this();
        this.setParentBeanFactory(parentBeanFactory);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.instantiationStrategy = instantiationStrategy;
    }

    protected InstantiationStrategy getInstantiationStrategy() {
        return this.instantiationStrategy;
    }

    public void setAllowCircularReferences(boolean allowCircularReferences) {
        this.allowCircularReferences = allowCircularReferences;
    }

    public void setAllowRawInjectionDespiteWrapping(boolean allowRawInjectionDespiteWrapping) {
        this.allowRawInjectionDespiteWrapping = allowRawInjectionDespiteWrapping;
    }

    public void ignoreDependencyType(Class type) {
        this.ignoredDependencyTypes.add(type);
    }

    public void ignoreDependencyInterface(Class ifc) {
        this.ignoredDependencyInterfaces.add(ifc);
    }

    public void copyConfigurationFrom(ConfigurableBeanFactory otherFactory) {
        super.copyConfigurationFrom(otherFactory);
        if (otherFactory instanceof AbstractAutowireCapableBeanFactory) {
            AbstractAutowireCapableBeanFactory otherAutowireFactory = (AbstractAutowireCapableBeanFactory)otherFactory;
            this.instantiationStrategy = otherAutowireFactory.instantiationStrategy;
            this.allowCircularReferences = otherAutowireFactory.allowCircularReferences;
            this.ignoredDependencyTypes.addAll(otherAutowireFactory.ignoredDependencyTypes);
            this.ignoredDependencyInterfaces.addAll(otherAutowireFactory.ignoredDependencyInterfaces);
        }
    }

    public Object createBean(Class beanClass) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass);
        bd.setScope("prototype");
        return this.createBean(beanClass.getName(), bd, null);
    }

    public void autowireBean(Object existingBean) {
        RootBeanDefinition bd = new RootBeanDefinition(ClassUtils.getUserClass(existingBean));
        bd.setScope("prototype");
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(bd.getBeanClass().getName(), bd, bw);
    }

    public Object configureBean(Object existingBean, String beanName) throws BeansException {
        RootBeanDefinition rbd;
        this.markBeanAsCreated(beanName);
        BeanDefinition mbd = this.getMergedBeanDefinition(beanName);
        RootBeanDefinition bd = null;
        if (mbd instanceof RootBeanDefinition && "prototype".equals((rbd = (RootBeanDefinition)mbd).getScope())) {
            bd = rbd;
        }
        if (bd == null) {
            bd = new RootBeanDefinition(mbd);
            bd.setScope("prototype");
        }
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(beanName, bd, bw);
        return this.initializeBean(beanName, existingBean, bd);
    }

    public Object resolveDependency(DependencyDescriptor descriptor, String beanName) throws BeansException {
        return this.resolveDependency(descriptor, beanName, null, null);
    }

    public Object createBean(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setScope("prototype");
        return this.createBean(beanClass.getName(), bd, null);
    }

    public Object autowire(Class beanClass, int autowireMode, boolean dependencyCheck) throws BeansException {
        RootBeanDefinition bd = new RootBeanDefinition(beanClass, autowireMode, dependencyCheck);
        bd.setScope("prototype");
        if (bd.getResolvedAutowireMode() == 3) {
            return this.autowireConstructor(beanClass.getName(), bd, null, null).getWrappedInstance();
        }
        Object bean = this.getInstantiationStrategy().instantiate(bd, null, this);
        this.populateBean(beanClass.getName(), bd, new BeanWrapperImpl(bean));
        return bean;
    }

    public void autowireBeanProperties(Object existingBean, int autowireMode, boolean dependencyCheck) throws BeansException {
        if (autowireMode == 3) {
            throw new IllegalArgumentException("AUTOWIRE_CONSTRUCTOR not supported for existing bean instance");
        }
        RootBeanDefinition bd = new RootBeanDefinition(ClassUtils.getUserClass(existingBean), autowireMode, dependencyCheck);
        bd.setScope("prototype");
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.populateBean(bd.getBeanClass().getName(), bd, bw);
    }

    public void applyBeanPropertyValues(Object existingBean, String beanName) throws BeansException {
        this.markBeanAsCreated(beanName);
        BeanDefinition bd = this.getMergedBeanDefinition(beanName);
        BeanWrapperImpl bw = new BeanWrapperImpl(existingBean);
        this.initBeanWrapper(bw);
        this.applyPropertyValues(beanName, bd, bw, bd.getPropertyValues());
    }

    public Object initializeBean(Object existingBean, String beanName) {
        return this.initializeBean(beanName, existingBean, null);
    }

    public Object applyBeanPostProcessorsBeforeInitialization(Object existingBean, String beanName) throws BeansException {
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessBeforeInitialization(result, beanName);
        }
        return result;
    }

    public Object applyBeanPostProcessorsAfterInitialization(Object existingBean, String beanName) throws BeansException {
        Object result = existingBean;
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            result = beanProcessor.postProcessAfterInitialization(result, beanName);
        }
        return result;
    }

    protected Object createBean(final String beanName, final RootBeanDefinition mbd, final Object[] args) throws BeanCreationException {
        AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (AbstractAutowireCapableBeanFactory.this.logger.isDebugEnabled()) {
                    AbstractAutowireCapableBeanFactory.this.logger.debug((Object)("Creating instance of bean '" + beanName + "'"));
                }
                AbstractAutowireCapableBeanFactory.this.resolveBeanClass(mbd, beanName);
                try {
                    mbd.prepareMethodOverrides();
                }
                catch (BeanDefinitionValidationException ex) {
                    throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "Validation of method overrides failed", ex);
                }
                try {
                    Object bean = AbstractAutowireCapableBeanFactory.this.resolveBeforeInstantiation(beanName, mbd);
                    if (bean != null) {
                        return bean;
                    }
                }
                catch (Throwable ex) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "BeanPostProcessor before instantiation of bean failed", ex);
                }
                Object beanInstance = AbstractAutowireCapableBeanFactory.this.doCreateBean(beanName, mbd, args);
                if (AbstractAutowireCapableBeanFactory.this.logger.isDebugEnabled()) {
                    AbstractAutowireCapableBeanFactory.this.logger.debug((Object)("Finished creating instance of bean '" + beanName + "'"));
                }
                return beanInstance;
            }
        }, acc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doCreateBean(final String beanName, final RootBeanDefinition mbd, Object[] args) {
        Object earlySingletonReference;
        boolean earlySingletonExposure;
        BeanWrapper instanceWrapper = null;
        if (mbd.isSingleton()) {
            instanceWrapper = (BeanWrapper)this.factoryBeanInstanceCache.remove(beanName);
        }
        if (instanceWrapper == null) {
            instanceWrapper = this.createBeanInstance(beanName, mbd, args);
        }
        final Object bean = instanceWrapper != null ? instanceWrapper.getWrappedInstance() : null;
        Class beanType = instanceWrapper != null ? instanceWrapper.getWrappedClass() : null;
        Object object = mbd.postProcessingLock;
        synchronized (object) {
            if (!mbd.postProcessed) {
                this.applyMergedBeanDefinitionPostProcessors(mbd, beanType, beanName);
                mbd.postProcessed = true;
            }
        }
        boolean bl = earlySingletonExposure = mbd.isSingleton() && this.allowCircularReferences && this.isSingletonCurrentlyInCreation(beanName);
        if (earlySingletonExposure) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Eagerly caching bean '" + beanName + "' to allow for resolving potential circular references"));
            }
            this.addSingletonFactory(beanName, new ObjectFactory(){

                public Object getObject() throws BeansException {
                    return AbstractAutowireCapableBeanFactory.this.getEarlyBeanReference(beanName, mbd, bean);
                }
            });
        }
        Object exposedObject = bean;
        try {
            this.populateBean(beanName, mbd, instanceWrapper);
            exposedObject = this.initializeBean(beanName, exposedObject, mbd);
        }
        catch (Throwable ex) {
            if (ex instanceof BeanCreationException && beanName.equals(((BeanCreationException)ex).getBeanName())) {
                throw (BeanCreationException)ex;
            }
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Initialization of bean failed", ex);
        }
        if (earlySingletonExposure && (earlySingletonReference = this.getSingleton(beanName, false)) != null) {
            if (exposedObject == bean) {
                exposedObject = earlySingletonReference;
            } else if (!this.allowRawInjectionDespiteWrapping && this.hasDependentBean(beanName)) {
                String[] dependentBeans = this.getDependentBeans(beanName);
                LinkedHashSet<String> actualDependentBeans = new LinkedHashSet<String>(dependentBeans.length);
                for (int i = 0; i < dependentBeans.length; ++i) {
                    String dependentBean = dependentBeans[i];
                    if (this.removeSingletonIfCreatedForTypeCheckOnly(dependentBean)) continue;
                    actualDependentBeans.add(dependentBean);
                }
                if (!actualDependentBeans.isEmpty()) {
                    throw new BeanCurrentlyInCreationException(beanName, "Bean with name '" + beanName + "' has been injected into other beans [" + StringUtils.collectionToCommaDelimitedString(actualDependentBeans) + "] in its raw version as part of a circular reference, but has eventually been " + "wrapped. This means that said other beans do not use the final version of the " + "bean. This is often the result of over-eager type matching - consider using " + "'getBeanNamesOfType' with the 'allowEagerInit' flag turned off, for example.");
                }
            }
        }
        this.registerDisposableBeanIfNecessary(beanName, bean, mbd);
        return exposedObject;
    }

    protected Class predictBeanType(String beanName, RootBeanDefinition mbd, Class[] typesToMatch) {
        Class beanClass = null;
        beanClass = mbd.getFactoryMethodName() != null ? this.getTypeForFactoryMethod(beanName, mbd, typesToMatch) : this.resolveBeanClass(mbd, beanName, typesToMatch);
        if (beanClass != null && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            Iterator it = this.getBeanPostProcessors().iterator();
            while (it.hasNext()) {
                SmartInstantiationAwareBeanPostProcessor ibp;
                Class processedType;
                BeanPostProcessor bp = (BeanPostProcessor)it.next();
                if (!(bp instanceof SmartInstantiationAwareBeanPostProcessor) || (processedType = (ibp = (SmartInstantiationAwareBeanPostProcessor)bp).predictBeanType(beanClass, beanName)) == null) continue;
                return processedType;
            }
        }
        return beanClass;
    }

    protected Class getTypeForFactoryMethod(String beanName, RootBeanDefinition mbd, Class[] typesToMatch) {
        Class factoryClass = null;
        boolean isStatic = true;
        String factoryBeanName = mbd.getFactoryBeanName();
        if (factoryBeanName != null) {
            if (factoryBeanName.equals(beanName)) {
                throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "factory-bean reference points back to the same bean definition");
            }
            factoryClass = this.getType(factoryBeanName);
            isStatic = false;
        } else {
            factoryClass = this.resolveBeanClass(mbd, beanName, typesToMatch);
        }
        if (factoryClass == null) {
            return null;
        }
        int minNrOfArgs = mbd.getConstructorArgumentValues().getArgumentCount();
        Method[] candidates = ReflectionUtils.getAllDeclaredMethods(factoryClass);
        HashSet returnTypes = new HashSet(1);
        for (int i = 0; i < candidates.length; ++i) {
            Method factoryMethod = candidates[i];
            if (Modifier.isStatic(factoryMethod.getModifiers()) != isStatic || !factoryMethod.getName().equals(mbd.getFactoryMethodName()) || factoryMethod.getParameterTypes().length < minNrOfArgs) continue;
            returnTypes.add(factoryMethod.getReturnType());
        }
        if (returnTypes.size() == 1) {
            return (Class)returnTypes.iterator().next();
        }
        return null;
    }

    protected Class getTypeForFactoryBean(String beanName, RootBeanDefinition mbd) {
        Class objectType;
        FactoryBean fb;
        FactoryBean factoryBean = fb = mbd.isSingleton() ? this.getSingletonFactoryBeanForTypeCheck(beanName, mbd) : this.getNonSingletonFactoryBeanForTypeCheck(beanName, mbd);
        if (fb != null && (objectType = this.getTypeForFactoryBean(fb)) != null) {
            return objectType;
        }
        return super.getTypeForFactoryBean(beanName, mbd);
    }

    protected Object getEarlyBeanReference(String beanName, RootBeanDefinition mbd, Object bean) {
        Object exposedObject = bean;
        if (!mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            Iterator it = this.getBeanPostProcessors().iterator();
            while (it.hasNext()) {
                BeanPostProcessor bp = (BeanPostProcessor)it.next();
                if (!(bp instanceof SmartInstantiationAwareBeanPostProcessor)) continue;
                SmartInstantiationAwareBeanPostProcessor ibp = (SmartInstantiationAwareBeanPostProcessor)bp;
                exposedObject = ibp.getEarlyBeanReference(exposedObject, beanName);
            }
        }
        return exposedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getSingletonFactoryBeanForTypeCheck(String beanName, RootBeanDefinition mbd) {
        Object object = this.getSingletonMutex();
        synchronized (object) {
            BeanWrapper bw = (BeanWrapper)this.factoryBeanInstanceCache.get(beanName);
            if (bw != null) {
                return (FactoryBean)bw.getWrappedInstance();
            }
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                return null;
            }
            Object instance = null;
            try {
                this.beforeSingletonCreation(beanName);
                instance = this.resolveBeforeInstantiation(beanName, mbd);
                if (instance == null) {
                    bw = this.createBeanInstance(beanName, mbd, null);
                    instance = bw.getWrappedInstance();
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.afterSingletonCreation(beanName);
                throw throwable;
            }
            this.afterSingletonCreation(beanName);
            FactoryBean fb = this.getFactoryBean(beanName, instance);
            if (bw != null) {
                this.factoryBeanInstanceCache.put(beanName, bw);
            }
            return fb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FactoryBean getNonSingletonFactoryBeanForTypeCheck(String beanName, RootBeanDefinition mbd) {
        if (this.isPrototypeCurrentlyInCreation(beanName)) {
            return null;
        }
        Object instance = null;
        try {
            this.beforePrototypeCreation(beanName);
            instance = this.resolveBeforeInstantiation(beanName, mbd);
            if (instance == null) {
                BeanWrapper bw = this.createBeanInstance(beanName, mbd, null);
                instance = bw.getWrappedInstance();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.afterPrototypeCreation(beanName);
            throw throwable;
        }
        this.afterPrototypeCreation(beanName);
        return this.getFactoryBean(beanName, instance);
    }

    protected void applyMergedBeanDefinitionPostProcessors(RootBeanDefinition mbd, Class beanType, String beanName) throws BeansException {
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            if (!(beanProcessor instanceof MergedBeanDefinitionPostProcessor)) continue;
            MergedBeanDefinitionPostProcessor bdp = (MergedBeanDefinitionPostProcessor)beanProcessor;
            bdp.postProcessMergedBeanDefinition(mbd, beanType, beanName);
        }
    }

    protected Object resolveBeforeInstantiation(String beanName, RootBeanDefinition mbd) {
        Object bean = null;
        if (!Boolean.FALSE.equals(mbd.beforeInstantiationResolved)) {
            if (mbd.hasBeanClass() && !mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors() && (bean = this.applyBeanPostProcessorsBeforeInstantiation(mbd.getBeanClass(), beanName)) != null) {
                bean = this.applyBeanPostProcessorsAfterInitialization(bean, beanName);
            }
            mbd.beforeInstantiationResolved = bean != null;
        }
        return bean;
    }

    protected Object applyBeanPostProcessorsBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        Iterator it = this.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            InstantiationAwareBeanPostProcessor ibp;
            Object result;
            BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
            if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (result = (ibp = (InstantiationAwareBeanPostProcessor)beanProcessor).postProcessBeforeInstantiation(beanClass, beanName)) == null) continue;
            return result;
        }
        return null;
    }

    protected BeanWrapper createBeanInstance(String beanName, RootBeanDefinition mbd, Object[] args) {
        Class beanClass = this.resolveBeanClass(mbd, beanName);
        if (mbd.getFactoryMethodName() != null) {
            return this.instantiateUsingFactoryMethod(beanName, mbd, args);
        }
        if (mbd.resolvedConstructorOrFactoryMethod != null) {
            if (mbd.constructorArgumentsResolved) {
                return this.autowireConstructor(beanName, mbd, null, args);
            }
            return this.instantiateBean(beanName, mbd);
        }
        Constructor[] ctors = this.determineConstructorsFromBeanPostProcessors(beanClass, beanName);
        if (ctors != null || mbd.getResolvedAutowireMode() == 3 || mbd.hasConstructorArgumentValues() || !ObjectUtils.isEmpty(args)) {
            return this.autowireConstructor(beanName, mbd, ctors, args);
        }
        return this.instantiateBean(beanName, mbd);
    }

    protected Constructor[] determineConstructorsFromBeanPostProcessors(Class beanClass, String beanName) throws BeansException {
        if (this.hasInstantiationAwareBeanPostProcessors()) {
            Iterator it = this.getBeanPostProcessors().iterator();
            while (it.hasNext()) {
                SmartInstantiationAwareBeanPostProcessor ibp;
                Constructor[] ctors;
                BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
                if (!(beanProcessor instanceof SmartInstantiationAwareBeanPostProcessor) || (ctors = (ibp = (SmartInstantiationAwareBeanPostProcessor)beanProcessor).determineCandidateConstructors(beanClass, beanName)) == null) continue;
                return ctors;
            }
        }
        return null;
    }

    protected BeanWrapper instantiateBean(String beanName, RootBeanDefinition mbd) {
        try {
            Object beanInstance = this.getInstantiationStrategy().instantiate(mbd, beanName, this);
            BeanWrapperImpl bw = new BeanWrapperImpl(beanInstance);
            this.initBeanWrapper(bw);
            return bw;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Instantiation of bean failed", ex);
        }
    }

    protected BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mbd, Object[] explicitArgs) {
        ConstructorResolver constructorResolver = new ConstructorResolver(this, this, this.getInstantiationStrategy(), this.getCustomTypeConverter());
        return constructorResolver.instantiateUsingFactoryMethod(beanName, mbd, explicitArgs);
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mbd, Constructor[] ctors, Object[] explicitArgs) {
        ConstructorResolver constructorResolver = new ConstructorResolver(this, this, this.getInstantiationStrategy(), this.getCustomTypeConverter());
        return constructorResolver.autowireConstructor(beanName, mbd, ctors, explicitArgs);
    }

    protected void populateBean(String beanName, AbstractBeanDefinition mbd, BeanWrapper bw) {
        boolean needsDepCheck;
        PropertyValues pvs = mbd.getPropertyValues();
        if (bw == null) {
            if (!pvs.isEmpty()) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Cannot apply property values to null instance");
            }
            return;
        }
        boolean continueWithPropertyPopulation = true;
        if (!mbd.isSynthetic() && this.hasInstantiationAwareBeanPostProcessors()) {
            Iterator it = this.getBeanPostProcessors().iterator();
            while (it.hasNext()) {
                InstantiationAwareBeanPostProcessor ibp;
                BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
                if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (ibp = (InstantiationAwareBeanPostProcessor)beanProcessor).postProcessAfterInstantiation(bw.getWrappedInstance(), beanName)) continue;
                continueWithPropertyPopulation = false;
                break;
            }
        }
        if (!continueWithPropertyPopulation) {
            return;
        }
        if (mbd.getResolvedAutowireMode() == 1 || mbd.getResolvedAutowireMode() == 2) {
            MutablePropertyValues newPvs = new MutablePropertyValues(pvs);
            if (mbd.getResolvedAutowireMode() == 1) {
                this.autowireByName(beanName, mbd, bw, newPvs);
            }
            if (mbd.getResolvedAutowireMode() == 2) {
                this.autowireByType(beanName, mbd, bw, newPvs);
            }
            pvs = newPvs;
        }
        boolean hasInstAwareBpps = this.hasInstantiationAwareBeanPostProcessors();
        boolean bl = needsDepCheck = mbd.getDependencyCheck() != 0;
        if (hasInstAwareBpps || needsDepCheck) {
            PropertyDescriptor[] filteredPds = this.filterPropertyDescriptorsForDependencyCheck(bw);
            if (hasInstAwareBpps) {
                Iterator it = this.getBeanPostProcessors().iterator();
                while (it.hasNext()) {
                    InstantiationAwareBeanPostProcessor ibp;
                    BeanPostProcessor beanProcessor = (BeanPostProcessor)it.next();
                    if (!(beanProcessor instanceof InstantiationAwareBeanPostProcessor) || (pvs = (ibp = (InstantiationAwareBeanPostProcessor)beanProcessor).postProcessPropertyValues(pvs, filteredPds, bw.getWrappedInstance(), beanName)) != null) continue;
                    return;
                }
            }
            if (needsDepCheck) {
                this.checkDependencies(beanName, mbd, filteredPds, pvs);
            }
        }
        this.applyPropertyValues(beanName, mbd, bw, pvs);
    }

    protected void autowireByName(String beanName, AbstractBeanDefinition mbd, BeanWrapper bw, MutablePropertyValues pvs) {
        String[] propertyNames = this.unsatisfiedNonSimpleProperties(mbd, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            if (this.containsBean(propertyName)) {
                Object bean = this.getBean(propertyName);
                pvs.addPropertyValue(propertyName, bean);
                this.registerDependentBean(propertyName, beanName);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Added autowiring by name from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + propertyName + "'"));
                continue;
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace((Object)("Not autowiring property '" + propertyName + "' of bean '" + beanName + "' by name: no matching bean found"));
        }
    }

    protected void autowireByType(String beanName, AbstractBeanDefinition mbd, BeanWrapper bw, MutablePropertyValues pvs) {
        TypeConverter converter = this.getCustomTypeConverter();
        if (converter == null) {
            converter = bw;
        }
        LinkedHashSet autowiredBeanNames = new LinkedHashSet(4);
        String[] propertyNames = this.unsatisfiedNonSimpleProperties(mbd, bw);
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            try {
                PropertyDescriptor pd = bw.getPropertyDescriptor(propertyName);
                MethodParameter methodParam = BeanUtils.getWriteMethodParameter(pd);
                boolean eager = !(class$org$springframework$core$PriorityOrdered == null ? AbstractAutowireCapableBeanFactory.class$("org.springframework.core.PriorityOrdered") : class$org$springframework$core$PriorityOrdered).isAssignableFrom(bw.getWrappedClass());
                DependencyDescriptor desc = new DependencyDescriptor(methodParam, false, eager);
                Object autowiredArgument = this.resolveDependency(desc, beanName, autowiredBeanNames, converter);
                if (autowiredArgument != null) {
                    pvs.addPropertyValue(propertyName, autowiredArgument);
                }
                Iterator it = autowiredBeanNames.iterator();
                while (it.hasNext()) {
                    String autowiredBeanName = (String)it.next();
                    this.registerDependentBean(autowiredBeanName, beanName);
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via property '" + propertyName + "' to bean named '" + autowiredBeanName + "'"));
                }
                autowiredBeanNames.clear();
                continue;
            }
            catch (BeansException ex) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, propertyName, ex);
            }
        }
    }

    protected String[] unsatisfiedNonSimpleProperties(AbstractBeanDefinition mbd, BeanWrapper bw) {
        TreeSet<String> result = new TreeSet<String>();
        MutablePropertyValues pvs = mbd.getPropertyValues();
        PropertyDescriptor[] pds = bw.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].getWriteMethod() == null || this.isExcludedFromDependencyCheck(pds[i]) || pvs.contains(pds[i].getName()) || BeanUtils.isSimpleProperty(pds[i].getPropertyType())) continue;
            result.add(pds[i].getName());
        }
        return StringUtils.toStringArray(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PropertyDescriptor[] filterPropertyDescriptorsForDependencyCheck(BeanWrapper bw) {
        Map map = this.filteredPropertyDescriptorsCache;
        synchronized (map) {
            PropertyDescriptor[] filtered = (PropertyDescriptor[])this.filteredPropertyDescriptorsCache.get(bw.getWrappedClass());
            if (filtered == null) {
                LinkedList<PropertyDescriptor> pds = new LinkedList<PropertyDescriptor>(Arrays.asList(bw.getPropertyDescriptors()));
                Iterator it = pds.iterator();
                while (it.hasNext()) {
                    PropertyDescriptor pd = (PropertyDescriptor)it.next();
                    if (!this.isExcludedFromDependencyCheck(pd)) continue;
                    it.remove();
                }
                filtered = pds.toArray(new PropertyDescriptor[pds.size()]);
                this.filteredPropertyDescriptorsCache.put(bw.getWrappedClass(), filtered);
            }
            return filtered;
        }
    }

    protected boolean isExcludedFromDependencyCheck(PropertyDescriptor pd) {
        return AutowireUtils.isExcludedFromDependencyCheck(pd) || this.ignoredDependencyTypes.contains(pd.getPropertyType()) || AutowireUtils.isSetterDefinedInInterface(pd, this.ignoredDependencyInterfaces);
    }

    protected void checkDependencies(String beanName, AbstractBeanDefinition mbd, PropertyDescriptor[] pds, PropertyValues pvs) throws UnsatisfiedDependencyException {
        int dependencyCheck = mbd.getDependencyCheck();
        for (int i = 0; i < pds.length; ++i) {
            boolean unsatisfied;
            if (pds[i].getWriteMethod() == null || pvs.contains(pds[i].getName())) continue;
            boolean isSimple = BeanUtils.isSimpleProperty(pds[i].getPropertyType());
            boolean bl = unsatisfied = dependencyCheck == 3 || isSimple && dependencyCheck == 2 || !isSimple && dependencyCheck == 1;
            if (!unsatisfied) continue;
            throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, pds[i].getName(), "Set this property value or disable dependency checking for this bean.");
        }
    }

    protected void applyPropertyValues(String beanName, BeanDefinition mbd, BeanWrapper bw, PropertyValues pvs) {
        if (pvs == null || pvs.isEmpty()) {
            return;
        }
        MutablePropertyValues mpvs = null;
        List original = null;
        if (pvs instanceof MutablePropertyValues) {
            mpvs = (MutablePropertyValues)pvs;
            if (mpvs.isConverted()) {
                try {
                    bw.setPropertyValues(mpvs);
                    return;
                }
                catch (BeansException ex) {
                    throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", ex);
                }
            }
            original = mpvs.getPropertyValueList();
        } else {
            original = Arrays.asList(pvs.getPropertyValues());
        }
        TypeConverter converter = this.getCustomTypeConverter();
        if (converter == null) {
            converter = bw;
        }
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this, beanName, mbd, converter);
        ArrayList<PropertyValue> deepCopy = new ArrayList<PropertyValue>(original.size());
        boolean resolveNecessary = false;
        Iterator it = original.iterator();
        while (it.hasNext()) {
            boolean convertible;
            Object resolvedValue;
            PropertyValue pv = (PropertyValue)it.next();
            if (pv.isConverted()) {
                deepCopy.add(pv);
                continue;
            }
            String propertyName = pv.getName();
            Object originalValue = pv.getValue();
            Object convertedValue = resolvedValue = valueResolver.resolveValueIfNecessary(pv, originalValue);
            boolean bl = convertible = !PropertyAccessorUtils.isNestedOrIndexedProperty(propertyName);
            if (convertible) {
                convertedValue = this.convertForProperty(resolvedValue, propertyName, bw, converter);
            }
            if (resolvedValue == originalValue) {
                if (convertible) {
                    pv.setConvertedValue(convertedValue);
                }
                deepCopy.add(pv);
                continue;
            }
            if (originalValue instanceof TypedStringValue && convertible) {
                pv.setConvertedValue(convertedValue);
                deepCopy.add(pv);
                continue;
            }
            resolveNecessary = true;
            deepCopy.add(new PropertyValue(pv, convertedValue));
        }
        if (mpvs != null && !resolveNecessary) {
            mpvs.setConverted();
        }
        try {
            bw.setPropertyValues(new MutablePropertyValues(deepCopy));
        }
        catch (BeansException ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Error setting property values", ex);
        }
    }

    private Object convertForProperty(Object value, String propertyName, BeanWrapper bw, TypeConverter converter) {
        if (converter instanceof BeanWrapperImpl) {
            return ((BeanWrapperImpl)converter).convertForProperty(value, propertyName);
        }
        PropertyDescriptor pd = bw.getPropertyDescriptor(propertyName);
        MethodParameter methodParam = BeanUtils.getWriteMethodParameter(pd);
        return converter.convertIfNecessary(value, pd.getPropertyType(), methodParam);
    }

    protected Object initializeBean(String beanName, Object bean, RootBeanDefinition mbd) {
        if (bean instanceof BeanNameAware) {
            ((BeanNameAware)bean).setBeanName(beanName);
        }
        if (bean instanceof BeanClassLoaderAware) {
            ((BeanClassLoaderAware)bean).setBeanClassLoader(this.getBeanClassLoader());
        }
        if (bean instanceof BeanFactoryAware) {
            ((BeanFactoryAware)bean).setBeanFactory(this);
        }
        Object wrappedBean = bean;
        if (mbd == null || !mbd.isSynthetic()) {
            wrappedBean = this.applyBeanPostProcessorsBeforeInitialization(wrappedBean, beanName);
        }
        try {
            this.invokeInitMethods(beanName, wrappedBean, mbd);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd != null ? mbd.getResourceDescription() : null, beanName, "Invocation of init method failed", ex);
        }
        if (mbd == null || !mbd.isSynthetic()) {
            wrappedBean = this.applyBeanPostProcessorsAfterInitialization(wrappedBean, beanName);
        }
        return wrappedBean;
    }

    protected void invokeInitMethods(String beanName, Object bean, RootBeanDefinition mbd) throws Throwable {
        String initMethodName;
        boolean isInitializingBean = bean instanceof InitializingBean;
        if (isInitializingBean && (mbd == null || !mbd.isExternallyManagedInitMethod("afterPropertiesSet"))) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Invoking afterPropertiesSet() on bean with name '" + beanName + "'"));
            }
            ((InitializingBean)bean).afterPropertiesSet();
        }
        String string = initMethodName = mbd != null ? mbd.getInitMethodName() : null;
        if (!(initMethodName == null || isInitializingBean && "afterPropertiesSet".equals(initMethodName) || mbd.isExternallyManagedInitMethod(initMethodName))) {
            this.invokeCustomInitMethod(beanName, bean, initMethodName, mbd.isEnforceInitMethod());
        }
    }

    protected void invokeCustomInitMethod(String beanName, Object bean, String initMethodName, boolean enforceInitMethod) throws Throwable {
        Method initMethod = BeanUtils.findMethod(bean.getClass(), initMethodName, null);
        if (initMethod == null) {
            if (enforceInitMethod) {
                throw new NoSuchMethodException("Couldn't find an init method named '" + initMethodName + "' on bean with name '" + beanName + "'");
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No default init method named '" + initMethodName + "' found on bean with name '" + beanName + "'"));
            }
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Invoking init method  '" + initMethodName + "' on bean with name '" + beanName + "'"));
        }
        ReflectionUtils.makeAccessible(initMethod);
        try {
            initMethod.invoke(bean, (Object[])null);
        }
        catch (InvocationTargetException ex) {
            throw ex.getTargetException();
        }
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) {
        return this.applyBeanPostProcessorsAfterInitialization(object, beanName);
    }

    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanInstanceCache.remove(beanName);
    }
}

