/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jms.listener;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.Lifecycle;
import org.springframework.jms.JmsException;
import org.springframework.jms.connection.ConnectionFactoryUtils;
import org.springframework.jms.support.JmsUtils;
import org.springframework.jms.support.destination.JmsDestinationAccessor;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractJmsListeningContainer
extends JmsDestinationAccessor
implements Lifecycle,
BeanNameAware,
DisposableBean {
    private String clientId;
    private boolean autoStartup = true;
    private String beanName;
    private Connection sharedConnection;
    private boolean sharedConnectionStarted = false;
    protected final Object sharedConnectionMonitor = new Object();
    private boolean active = false;
    private boolean running = false;
    private final List pausedTasks = new LinkedList();
    protected final Object lifecycleMonitor = new Object();

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected final String getBeanName() {
        return this.beanName;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.validateConfiguration();
        this.initialize();
    }

    protected void validateConfiguration() {
    }

    public void destroy() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws JmsException {
        try {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.active = true;
                this.lifecycleMonitor.notifyAll();
            }
            if (this.autoStartup) {
                this.doStart();
            }
            this.doInitialize();
        }
        catch (JMSException ex) {
            Object object = this.sharedConnectionMonitor;
            synchronized (object) {
                ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), this.autoStartup);
            }
            throw this.convertJmsAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void shutdown() throws JmsException {
        this.logger.debug((Object)"Shutting down JMS listener container");
        boolean wasRunning = false;
        Object object2 = this.lifecycleMonitor;
        // MONITORENTER : object2
        wasRunning = this.running;
        this.running = false;
        this.active = false;
        this.lifecycleMonitor.notifyAll();
        // MONITOREXIT : object2
        if (wasRunning && this.sharedConnectionEnabled()) {
            try {
                this.stopSharedConnection();
            }
            catch (Throwable ex) {
                this.logger.debug((Object)"Could not stop JMS Connection on shutdown", ex);
            }
        }
        try {
            try {
                this.doShutdown();
            }
            catch (JMSException ex) {
                throw this.convertJmsAccessException(ex);
            }
            Object var5_5 = null;
            if (!this.sharedConnectionEnabled()) return;
            Object object = this.sharedConnectionMonitor;
            // MONITORENTER : object
            ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), false);
            this.sharedConnection = null;
            // MONITOREXIT : object
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!this.sharedConnectionEnabled()) throw throwable;
            Object object = this.sharedConnectionMonitor;
            // MONITORENTER : object
            ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), false);
            this.sharedConnection = null;
            // MONITOREXIT : object
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isActive() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    public void start() throws JmsException {
        try {
            this.doStart();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws JMSException {
        if (this.sharedConnectionEnabled()) {
            this.establishSharedConnection();
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = true;
            this.lifecycleMonitor.notifyAll();
            this.resumePausedTasks();
        }
        if (this.sharedConnectionEnabled()) {
            this.startSharedConnection();
        }
    }

    public void stop() throws JmsException {
        try {
            this.doStop();
        }
        catch (JMSException ex) {
            throw this.convertJmsAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws JMSException {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.running = false;
            this.lifecycleMonitor.notifyAll();
        }
        if (this.sharedConnectionEnabled()) {
            this.stopSharedConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running && this.runningAllowed();
        }
    }

    protected boolean runningAllowed() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitWhileNotRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            boolean interrupted = false;
            while (this.active && !this.isRunning()) {
                if (interrupted) {
                    throw new java.lang.IllegalStateException("Thread was interrupted while waiting for a restart of the listener container, but container is still stopped");
                }
                try {
                    this.lifecycleMonitor.wait();
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    interrupted = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void establishSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            if (this.sharedConnection == null) {
                this.sharedConnection = this.createSharedConnection();
                this.logger.debug((Object)"Established shared JMS Connection");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void refreshSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            ConnectionFactoryUtils.releaseConnection(this.sharedConnection, this.getConnectionFactory(), this.sharedConnectionStarted);
            this.sharedConnection = this.createSharedConnection();
            if (this.sharedConnectionStarted) {
                this.sharedConnection.start();
            }
        }
    }

    protected Connection createSharedConnection() throws JMSException {
        Connection con = this.createConnection();
        try {
            this.prepareSharedConnection(con);
            return con;
        }
        catch (JMSException ex) {
            JmsUtils.closeConnection(con);
            throw ex;
        }
    }

    protected void prepareSharedConnection(Connection connection) throws JMSException {
        String clientId = this.getClientId();
        if (clientId != null) {
            connection.setClientID(clientId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            this.sharedConnectionStarted = true;
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.start();
                }
                catch (IllegalStateException ex) {
                    this.logger.debug((Object)("Ignoring Connection start exception - assuming already started: " + (Object)((Object)ex)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSharedConnection() throws JMSException {
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            this.sharedConnectionStarted = false;
            if (this.sharedConnection != null) {
                try {
                    this.sharedConnection.stop();
                }
                catch (IllegalStateException ex) {
                    this.logger.debug((Object)("Ignoring Connection stop exception - assuming already stopped: " + (Object)((Object)ex)));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Connection getSharedConnection() {
        if (!this.sharedConnectionEnabled()) {
            throw new java.lang.IllegalStateException("This listener container does not maintain a shared Connection");
        }
        Object object = this.sharedConnectionMonitor;
        synchronized (object) {
            if (this.sharedConnection == null) {
                throw new SharedConnectionNotInitializedException("This listener container's shared Connection has not been initialized yet");
            }
            return this.sharedConnection;
        }
    }

    protected final boolean rescheduleTaskIfNecessary(Object task) {
        Assert.notNull(task, "Task object must not be null");
        if (this.running) {
            try {
                this.doRescheduleTask(task);
            }
            catch (RuntimeException ex) {
                this.logRejectedTask(task, ex);
                this.pausedTasks.add(task);
            }
            return true;
        }
        if (this.active) {
            this.pausedTasks.add(task);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resumePausedTasks() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (!this.pausedTasks.isEmpty()) {
                Iterator it = this.pausedTasks.iterator();
                while (it.hasNext()) {
                    Object task = it.next();
                    try {
                        this.doRescheduleTask(task);
                        it.remove();
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug((Object)("Resumed paused task: " + task));
                    }
                    catch (RuntimeException ex) {
                        this.logRejectedTask(task, ex);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPausedTaskCount() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.pausedTasks.size();
        }
    }

    protected void doRescheduleTask(Object task) {
        throw new UnsupportedOperationException(ClassUtils.getShortName(this.getClass()) + " does not support rescheduling of tasks");
    }

    protected void logRejectedTask(Object task, RuntimeException ex) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Listener container task [" + task + "] has been rejected and paused: " + ex));
        }
    }

    protected abstract boolean sharedConnectionEnabled();

    protected abstract void doInitialize() throws JMSException;

    protected abstract void doShutdown() throws JMSException;

    public static class SharedConnectionNotInitializedException
    extends RuntimeException {
        protected SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }
}

