/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.Date;
import liquibase.ChangeSet;

public class RanChangeSet {
    private final String changeLog;
    private final String id;
    private final String author;
    private final String md5sum;
    private final Date dateExecuted;
    private String tag;

    public RanChangeSet(ChangeSet changeSet) {
        this(changeSet.getFilePath(), changeSet.getId(), changeSet.getAuthor(), changeSet.getMd5sum(), new Date(), null);
    }

    public RanChangeSet(String changeLog, String id, String author, String md5sum, Date dateExecuted, String tag) {
        this.changeLog = changeLog;
        this.id = id;
        this.author = author;
        this.md5sum = md5sum;
        this.dateExecuted = dateExecuted == null ? null : new Date(dateExecuted.getTime());
        this.tag = tag;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getMd5sum() {
        return this.md5sum;
    }

    public Date getDateExecuted() {
        if (this.dateExecuted == null) {
            return null;
        }
        return (Date)this.dateExecuted.clone();
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RanChangeSet that = (RanChangeSet)o;
        return this.author.equals(that.author) && this.changeLog.equals(that.changeLog) && this.id.equals(that.id);
    }

    public int hashCode() {
        int result = this.changeLog.hashCode();
        result = 29 * result + this.id.hashCode();
        result = 29 * result + this.author.hashCode();
        return result;
    }

    public boolean isSameAs(ChangeSet changeSet) {
        return this.getChangeLog().replace('\\', '/').equals(changeSet.getFilePath().replace('\\', '/')) && this.getId().equals(changeSet.getId()) && this.getAuthor().equals(changeSet.getAuthor());
    }
}

