/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ant;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import liquibase.FileOpener;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntFileOpener
implements FileOpener {
    private AntClassLoader loader;

    public AntFileOpener(final Project project, final Path classpath) {
        this.loader = AccessController.doPrivileged(new PrivilegedAction<AntClassLoader>(){

            @Override
            public AntClassLoader run() {
                return new AntClassLoader(project, classpath);
            }
        });
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        URL resource = this.loader.getResource(file);
        if (resource == null) {
            return null;
        }
        return resource.openStream();
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        return this.loader.getResources(packageName);
    }

    @Override
    public ClassLoader toClassLoader() {
        return this.loader;
    }
}

