/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import liquibase.CompositeFileOpener;
import liquibase.FileOpener;
import liquibase.FileSystemFileOpener;
import liquibase.Liquibase;
import liquibase.ant.AntFileOpener;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.HibernateDatabase;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class BaseLiquibaseTask
extends Task {
    private String changeLogFile;
    private String driver;
    private String url;
    private String username;
    private String password;
    protected Path classpath;
    private boolean promptOnNonLocalDatabase = false;
    private String currentDateTimeFunction;
    private String contexts;
    private String outputFile;
    private String defaultSchemaName;
    private String databaseClass;
    private String databaseChangeLogTableName;
    private String databaseChangeLogLockTableName;
    private Map<String, Object> changeLogProperties = new HashMap<String, Object>();

    public BaseLiquibaseTask() {
        new LogRedirector(this).redirectLogger();
    }

    public boolean isPromptOnNonLocalDatabase() {
        return this.promptOnNonLocalDatabase;
    }

    public void setPromptOnNonLocalDatabase(boolean promptOnNonLocalDatabase) {
        this.promptOnNonLocalDatabase = promptOnNonLocalDatabase;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver.trim();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url.trim();
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username.trim();
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password.trim();
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile.trim();
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public String getCurrentDateTimeFunction() {
        return this.currentDateTimeFunction;
    }

    public void setCurrentDateTimeFunction(String currentDateTimeFunction) {
        this.currentDateTimeFunction = currentDateTimeFunction.trim();
    }

    public String getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile.trim();
    }

    public Writer createOutputWriter() throws IOException {
        if (this.outputFile == null) {
            return null;
        }
        return new FileWriter(new File(this.getOutputFile()));
    }

    public PrintStream createPrintStream() throws IOException {
        if (this.outputFile == null) {
            return null;
        }
        return new PrintStream(new File(this.getOutputFile()));
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName.trim();
    }

    public void addConfiguredChangeLogProperty(ChangeLogProperty changeLogProperty) {
        this.changeLogProperties.put(changeLogProperty.getName(), changeLogProperty.getValue());
    }

    protected Liquibase createLiquibase() throws Exception {
        AntFileOpener antFO = new AntFileOpener(this.getProject(), this.classpath);
        FileSystemFileOpener fsFO = new FileSystemFileOpener();
        Database database = this.createDatabaseObject(this.getDriver(), this.getUrl(), this.getUsername(), this.getPassword(), this.getDefaultSchemaName(), this.getDatabaseClass());
        String changeLogFile = null;
        if (this.getChangeLogFile() != null) {
            changeLogFile = this.getChangeLogFile().trim();
        }
        Liquibase liquibase = new Liquibase(changeLogFile, (FileOpener)new CompositeFileOpener(antFO, fsFO), database);
        liquibase.setCurrentDateTimeFunction(this.currentDateTimeFunction);
        for (Map.Entry<String, Object> entry : this.changeLogProperties.entrySet()) {
            liquibase.setChangeLogParameterValue(entry.getKey(), entry.getValue());
        }
        return liquibase;
    }

    protected Database createDatabaseObject(String driverClassName, String databaseUrl, String username, String password, String defaultSchemaName, String databaseClass) throws Exception {
        Database database;
        String[] strings = this.classpath.list();
        final ArrayList<URL> taskClassPath = new ArrayList<URL>();
        for (String string : strings) {
            URL url = new File(string).toURL();
            taskClassPath.add(url);
        }
        URLClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<URLClassLoader>(){

            @Override
            public URLClassLoader run() {
                return new URLClassLoader(taskClassPath.toArray(new URL[taskClassPath.size()]));
            }
        });
        if (databaseUrl.startsWith("hibernate:")) {
            database = new HibernateDatabase(databaseUrl.substring("hibernate:".length()));
        } else {
            if (databaseClass != null) {
                try {
                    DatabaseFactory.getInstance().addDatabaseImplementation((Database)Class.forName(databaseClass, true, loader).newInstance());
                }
                catch (ClassCastException e) {
                    DatabaseFactory.getInstance().addDatabaseImplementation((Database)Class.forName(databaseClass).newInstance());
                }
            }
            if (driverClassName == null) {
                driverClassName = DatabaseFactory.getInstance().findDefaultDriver(databaseUrl);
            }
            if (driverClassName == null) {
                throw new JDBCException("driver not specified and no default could be found for " + databaseUrl);
            }
            Driver driver = (Driver)Class.forName(driverClassName, true, loader).newInstance();
            Properties info = new Properties();
            info.put("user", username);
            info.put("password", password);
            Connection connection = driver.connect(databaseUrl, info);
            if (connection == null) {
                throw new JDBCException("Connection could not be created to " + databaseUrl + " with driver " + driver.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
            }
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(connection);
            database.setDefaultSchemaName(defaultSchemaName);
        }
        if (this.getDatabaseChangeLogTableName() != null) {
            database.setDatabaseChangeLogTableName(this.getDatabaseChangeLogTableName());
        }
        if (this.getDatabaseChangeLogLockTableName() != null) {
            database.setDatabaseChangeLogLockTableName(this.getDatabaseChangeLogLockTableName());
        }
        return database;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String cntx) {
        this.contexts = cntx.trim();
    }

    protected boolean shouldRun() {
        String shouldRunProperty = System.getProperty("liquibase.should.run");
        if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
            this.log("LiquiBase did not run because 'liquibase.should.run' system property was set to false");
            return false;
        }
        return true;
    }

    protected void closeDatabase(Liquibase liquibase) {
        if (liquibase != null && liquibase.getDatabase() != null && liquibase.getDatabase().getConnection() != null) {
            try {
                liquibase.getDatabase().close();
            }
            catch (JDBCException e) {
                this.log("Error closing database: " + e.getMessage());
            }
        }
    }

    public String getDatabaseClass() {
        return this.databaseClass;
    }

    public void setDatabaseClass(String databaseClass) {
        this.databaseClass = databaseClass;
    }

    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    public void setDatabaseChangeLogTableName(String tableName) {
        this.databaseChangeLogTableName = tableName;
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    public void setDatabaseChangeLogLockTableName(String tableName) {
        this.databaseChangeLogLockTableName = tableName;
    }

    public static class ChangeLogProperty {
        private String name;
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    protected static class LogRedirector {
        private final Task task;

        protected LogRedirector(Task task) {
            this.task = task;
        }

        protected void redirectLogger() {
            this.registerHandler(this.createHandler());
        }

        protected void registerHandler(Handler theHandler) {
            Logger logger = LogFactory.getLogger();
            for (Handler handler : logger.getHandlers()) {
                logger.removeHandler(handler);
            }
            logger.addHandler(theHandler);
            logger.setUseParentHandlers(false);
        }

        protected Handler createHandler() {
            return new Handler(){

                public void publish(LogRecord logRecord) {
                    LogRedirector.this.task.log(logRecord.getMessage(), this.mapLevelToAntLevel(logRecord.getLevel()));
                }

                public void close() throws SecurityException {
                }

                public void flush() {
                }

                protected int mapLevelToAntLevel(Level level) {
                    if (Level.ALL == level) {
                        return 2;
                    }
                    if (Level.SEVERE == level) {
                        return 0;
                    }
                    if (Level.WARNING == level) {
                        return 1;
                    }
                    if (Level.INFO == level) {
                        return 2;
                    }
                    return 3;
                }
            };
        }
    }
}

