/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.RenameColumnStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameColumnChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String oldColumnName;
    private String newColumnName;
    private String columnDataType;

    public RenameColumnChange() {
        super("renameColumn", "Rename Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getOldColumnName() {
        return this.oldColumnName;
    }

    public void setOldColumnName(String oldColumnName) {
        this.oldColumnName = oldColumnName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.oldColumnName) == null) {
            throw new InvalidChangeDefinitionException("oldColumnName is required", this);
        }
        if (StringUtils.trimToNull(this.newColumnName) == null) {
            throw new InvalidChangeDefinitionException("newColumnName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{new RenameColumnStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.getOldColumnName(), this.getNewColumnName(), this.getColumnDataType())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                if (column.getName().equals(RenameColumnChange.this.getOldColumnName())) {
                    column.setName(RenameColumnChange.this.getNewColumnName());
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                if (index.getColumns().contains(RenameColumnChange.this.getOldColumnName())) {
                    index.getColumns().remove(RenameColumnChange.this.getOldColumnName());
                    index.getColumns().add(RenameColumnChange.this.getNewColumnName());
                }
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        RenameColumnChange inverse = new RenameColumnChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setOldColumnName(this.getNewColumnName());
        inverse.setNewColumnName(this.getOldColumnName());
        inverse.setColumnDataType(this.getColumnDataType());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return "Column " + this.tableName + "." + this.oldColumnName + " renamed to " + this.newColumnName;
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement("renameColumn");
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        node.setAttribute("tableName", this.getTableName());
        node.setAttribute("oldColumnName", this.getOldColumnName());
        node.setAttribute("newColumnName", this.getNewColumnName());
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table table = new Table(this.getTableName());
        Column oldColumn = new Column();
        oldColumn.setTable(table);
        oldColumn.setName(this.getOldColumnName());
        Column newColumn = new Column();
        newColumn.setTable(table);
        newColumn.setName(this.getNewColumnName());
        return new HashSet<Comparable>(Arrays.asList(table, oldColumn, newColumn));
    }
}

