/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;
import liquibase.preconditions.PreconditionLogic;

public class NotPrecondition
extends PreconditionLogic {
    public void check(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        for (Precondition precondition : this.getNestedPreconditions()) {
            boolean threwException = false;
            try {
                precondition.check(database, changeLog);
            }
            catch (PreconditionFailedException e) {
                threwException = true;
            }
            if (threwException) continue;
            throw new PreconditionFailedException("Not precondition failed", changeLog, this);
        }
    }

    public String getTagName() {
        return "not";
    }
}

