/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.util.HashMap;
import java.util.Map;
import liquibase.preconditions.AndPrecondition;
import liquibase.preconditions.ChangeSetExecutedPrecondition;
import liquibase.preconditions.ColumnExistsPrecondition;
import liquibase.preconditions.CustomPreconditionWrapper;
import liquibase.preconditions.DBMSPrecondition;
import liquibase.preconditions.ForeignKeyExistsPrecondition;
import liquibase.preconditions.IndexExistsPrecondition;
import liquibase.preconditions.NotPrecondition;
import liquibase.preconditions.OrPrecondition;
import liquibase.preconditions.Precondition;
import liquibase.preconditions.PrimaryKeyExistsPrecondition;
import liquibase.preconditions.RunningAsPrecondition;
import liquibase.preconditions.SequenceExistsPrecondition;
import liquibase.preconditions.SqlPrecondition;
import liquibase.preconditions.TableExistsPrecondition;
import liquibase.preconditions.ViewExistsPrecondition;

public class PreconditionFactory {
    private final Map<String, Class> tagToClassMap = new HashMap<String, Class>();
    private static final PreconditionFactory instance = new PreconditionFactory();

    private PreconditionFactory() {
        Class[] preconditions = new Class[]{AndPrecondition.class, OrPrecondition.class, NotPrecondition.class, DBMSPrecondition.class, RunningAsPrecondition.class, ChangeSetExecutedPrecondition.class, TableExistsPrecondition.class, ColumnExistsPrecondition.class, SequenceExistsPrecondition.class, ForeignKeyExistsPrecondition.class, IndexExistsPrecondition.class, PrimaryKeyExistsPrecondition.class, ViewExistsPrecondition.class, SqlPrecondition.class, CustomPreconditionWrapper.class};
        try {
            for (Class preconditionClass : preconditions) {
                Precondition precondition = (Precondition)preconditionClass.newInstance();
                this.tagToClassMap.put(precondition.getTagName(), preconditionClass);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static PreconditionFactory getInstance() {
        return instance;
    }

    public Precondition create(String tagName) {
        Class aClass = this.tagToClassMap.get(tagName);
        if (aClass == null) {
            throw new RuntimeException("Unknown tag: " + tagName);
        }
        try {
            return (Precondition)aClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

