/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.sql.CallableSqlStatement;
import liquibase.database.sql.SqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureStatement
implements SqlStatement,
CallableSqlStatement {
    private String procedureName;
    private List<String> parameters = new ArrayList<String>();
    private List<Integer> types = new ArrayList<Integer>();

    public StoredProcedureStatement(String procedureName) {
        this.procedureName = procedureName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public List<String> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public void addParameter(String param, int type) {
        this.parameters.add(param);
        this.types.add(type);
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    @Override
    public String getSqlStatement(Database database) {
        StringBuffer string = new StringBuffer();
        string.append("exec (").append(this.procedureName);
        for (String param : this.getParameters()) {
            string.append(" ").append(param).append(",");
        }
        return string.toString().replaceFirst(",$", ")");
    }

    @Override
    public CallableStatement createCallableStatement(Database database) throws SQLException {
        StringBuffer sql = new StringBuffer("{call " + this.getProcedureName());
        if (this.parameters.size() > 0) {
            sql.append("(");
            for (String param : this.parameters) {
                sql.append("?,");
            }
            sql.deleteCharAt(sql.lastIndexOf(","));
            sql.append(")");
        }
        sql.append("}");
        CallableStatement pstmt = database.getConnection().prepareCall(sql.toString());
        for (int i = 0; i < this.parameters.size(); ++i) {
            String param = this.parameters.get(i);
            int type = database.getDatabaseType(this.types.get(i));
            if (param == null) {
                pstmt.setNull(i + 1, type);
                continue;
            }
            pstmt.setObject(i + 1, (Object)param, type);
        }
        return pstmt;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }
}

