/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.RanChangeSet;
import liquibase.database.DataType;
import liquibase.database.DatabaseConnection;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.template.JdbcTemplate;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Database
extends DatabaseObject {
    public boolean isCorrectDatabaseImplementation(Connection var1) throws JDBCException;

    public String getDefaultDriver(String var1);

    public DatabaseConnection getConnection();

    public void setConnection(Connection var1);

    public void setConnection(DatabaseConnection var1);

    public boolean getAutoCommitMode();

    public boolean supportsDDLInTransaction();

    public String getDatabaseProductName();

    public String getDatabaseProductVersion() throws JDBCException;

    public int getDatabaseMajorVersion() throws JDBCException;

    public int getDatabaseMinorVersion() throws JDBCException;

    public String getProductName();

    public String getTypeName();

    public String getDriverName() throws JDBCException;

    public String getConnectionURL() throws JDBCException;

    public String getConnectionUsername() throws JDBCException;

    public String getDefaultCatalogName() throws JDBCException;

    public String getDefaultSchemaName();

    public void setDefaultSchemaName(String var1) throws JDBCException;

    public boolean supportsInitiallyDeferrableColumns();

    public boolean supportsSequences();

    public boolean supportsAutoIncrement();

    public String getColumnType(String var1, Boolean var2);

    public String getFalseBooleanValue();

    public String getTrueBooleanValue();

    public String getDateLiteral(String var1);

    public String getCurrentDateTimeFunction();

    public void setCurrentDateTimeFunction(String var1);

    public String getLineComment();

    public String getAutoIncrementClause();

    public String getDatabaseChangeLogTableName();

    public String getDatabaseChangeLogLockTableName();

    public void setDatabaseChangeLogTableName(String var1);

    public void setDatabaseChangeLogLockTableName(String var1);

    public String getConcatSql(String ... var1);

    public boolean doesChangeLogTableExist() throws JDBCException;

    public boolean doesChangeLogLockTableExist() throws JDBCException;

    public void checkDatabaseChangeLogTable() throws JDBCException;

    public void checkDatabaseChangeLogLockTable() throws JDBCException;

    public void dropDatabaseObjects(String var1) throws JDBCException;

    public void tag(String var1) throws JDBCException;

    public boolean doesTagExist(String var1) throws JDBCException;

    public boolean isSystemTable(String var1, String var2, String var3);

    public boolean isLiquibaseTable(String var1);

    public SqlStatement createFindSequencesSQL(String var1) throws JDBCException;

    public boolean shouldQuoteValue(String var1);

    public boolean supportsTablespaces();

    public String getViewDefinition(String var1, String var2) throws JDBCException;

    public int getDatabaseType(int var1);

    public String getDatabaseProductName(Connection var1) throws JDBCException;

    public DataType getCharType();

    public DataType getVarcharType();

    public DataType getBooleanType();

    public DataType getCurrencyType();

    public DataType getUUIDType();

    public DataType getClobType();

    public DataType getBlobType();

    public DataType getDateType();

    public DataType getFloatType();

    public DataType getDoubleType();

    public DataType getIntType();

    public DataType getTinyIntType();

    public DataType getDateTimeType();

    public DataType getTimeType();

    public DataType getBigIntType();

    public Object convertDatabaseValueToJavaObject(Object var1, int var2, int var3, int var4) throws ParseException;

    public String convertJavaObjectToString(Object var1);

    public boolean isSystemView(String var1, String var2, String var3);

    public String getDateLiteral(Date var1);

    public String getDateLiteral(Time var1);

    public String getDateLiteral(Timestamp var1);

    public String getDateLiteral(java.util.Date var1);

    public String escapeTableName(String var1, String var2);

    public String escapeIndexName(String var1, String var2);

    public String escapeColumnName(String var1, String var2, String var3);

    public String escapeColumnNameList(String var1);

    public String convertRequestedSchemaToSchema(String var1) throws JDBCException;

    public String convertRequestedSchemaToCatalog(String var1) throws JDBCException;

    public boolean supportsSchemas();

    public String generatePrimaryKeyName(String var1);

    public String escapeSequenceName(String var1, String var2);

    public String escapeViewName(String var1, String var2);

    public boolean isColumnAutoIncrement(String var1, String var2, String var3) throws SQLException, JDBCException;

    public ChangeSet.RunStatus getRunStatus(ChangeSet var1) throws JDBCException, DatabaseHistoryException;

    public RanChangeSet getRanChangeSet(ChangeSet var1) throws JDBCException, DatabaseHistoryException;

    public void markChangeSetAsRan(ChangeSet var1) throws JDBCException;

    public void markChangeSetAsReRan(ChangeSet var1) throws JDBCException;

    public List<RanChangeSet> getRanChangeSetList() throws JDBCException;

    public java.util.Date getRanDate(ChangeSet var1) throws JDBCException, DatabaseHistoryException;

    public void removeRanStatus(ChangeSet var1) throws JDBCException;

    public void commit() throws JDBCException;

    public void rollback() throws JDBCException;

    public SqlStatement getSelectChangeLogLockSQL() throws JDBCException;

    public JdbcTemplate getJdbcTemplate();

    public void setJdbcTemplate(JdbcTemplate var1);

    public String escapeStringForDatabase(String var1);

    public void close() throws JDBCException;

    public DatabaseSnapshot createDatabaseSnapshot(String var1, Set<DiffStatusListener> var2) throws JDBCException;

    public boolean supportsRestrictForeignKeys();

    public String escapeConstraintName(String var1);

    public boolean isAutoCommit() throws JDBCException;

    public void setAutoCommit(boolean var1) throws JDBCException;

    public boolean isLocalDatabase() throws JDBCException;
}

