/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import liquibase.database.DB2Database;
import liquibase.database.DataType;
import liquibase.exception.JDBCException;

public class DB2iDatabase
extends DB2Database {
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return this.getDatabaseProductName(conn).startsWith("DB2 UDB for AS/400");
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:as400")) {
            return "com.ibm.as400.access.AS400JDBCDriver";
        }
        return null;
    }

    public String getProductName() {
        return "DB2 for IBM i";
    }

    public String getTypeName() {
        return "db2i";
    }

    public DataType getFloatType() {
        return new DataType("DECIMAL", true);
    }
}

