/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.RanChangeSet;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class ChangeSetExecutedPrecondition
implements Precondition {
    private String changeLogFile;
    private String id;
    private String author;

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void check(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        RanChangeSet ranChangeSet;
        ChangeSet changeSet = new ChangeSet(this.getId(), this.getAuthor(), false, false, this.getChangeLogFile(), this.getChangeLogFile(), null, null, false);
        try {
            ranChangeSet = database.getRanChangeSet(changeSet);
        }
        catch (Exception e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
        if (ranChangeSet == null) {
            throw new PreconditionFailedException("Change Set '" + changeSet.toString(false) + "' has not been run", changeLog, this);
        }
    }

    public String getTagName() {
        return "changeSetExecuted";
    }
}

