/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class DBMSPrecondition
implements Precondition {
    private String type;

    public String getType() {
        return this.type;
    }

    public void setType(String atype) {
        this.type = atype.toLowerCase();
    }

    public void check(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        try {
            String dbType = database.getTypeName();
            if (!this.type.equals(dbType)) {
                throw new PreconditionFailedException("DBMS Precondition failed: expected " + this.type + ", got " + dbType, changeLog, this);
            }
        }
        catch (PreconditionFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
    }

    public String getTagName() {
        return "dbms";
    }
}

