/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.DropViewStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.View;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropViewChange
extends AbstractChange {
    private String schemaName;
    private String viewName;

    public DropViewChange() {
        super("dropView", "Drop View");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.viewName) == null) {
            throw new InvalidChangeDefinitionException("viewName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        return new SqlStatement[]{new DropViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName())};
    }

    @Override
    public String getConfirmationMessage() {
        return "View " + this.getViewName() + " dropped";
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement("dropView");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("viewName", this.getViewName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        View dbObject = new View();
        dbObject.setName(this.viewName);
        return new HashSet<DatabaseObject>(Arrays.asList(dbObject));
    }
}

