/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.LoadDataColumnConfig;
import liquibase.csv.CSVReader;
import liquibase.database.Database;
import liquibase.database.sql.InsertStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.MD5Util;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadDataChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private String file;
    private String encoding = null;
    private List<LoadDataColumnConfig> columns = new ArrayList<LoadDataColumnConfig>();

    public LoadDataChange() {
        super("loadData", "Load Data");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add((LoadDataColumnConfig)column);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        try {
            InputStream stream = this.getFileOpener().getResourceAsStream(this.getFile());
            if (stream == null) {
                throw new UnsupportedChangeException("Data file " + this.getFile() + " was not found");
            }
            InputStreamReader streamReader = this.getEncoding() == null ? new InputStreamReader(stream) : new InputStreamReader(stream, this.getEncoding());
            CSVReader reader = new CSVReader(streamReader);
            String[] headers = reader.readNext();
            if (headers == null) {
                throw new UnsupportedChangeException("Data file " + this.getFile() + " was empty");
            }
            ArrayList<InsertStatement> statements = new ArrayList<InsertStatement>();
            String[] line = null;
            while ((line = reader.readNext()) != null) {
                InsertStatement insertStatement = new InsertStatement(this.getSchemaName(), this.getTableName());
                for (int i = 0; i < headers.length; ++i) {
                    String columnName = null;
                    Object value = line[i];
                    ColumnConfig columnConfig = this.getColumnConfig(i, headers[i]);
                    if (columnConfig != null) {
                        columnName = columnConfig.getName();
                        if (value.toString().equalsIgnoreCase("NULL")) {
                            value = "NULL";
                        } else if (columnConfig.getType() != null) {
                            ColumnConfig valueConfig = new ColumnConfig();
                            if (columnConfig.getType().equalsIgnoreCase("BOOLEAN")) {
                                valueConfig.setValueBoolean(Boolean.parseBoolean(value.toString().toLowerCase()));
                            } else if (columnConfig.getType().equalsIgnoreCase("NUMERIC")) {
                                valueConfig.setValueNumeric(value.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("DATE")) {
                                valueConfig.setValueDate(value.toString());
                            } else if (columnConfig.getType().equalsIgnoreCase("STRING")) {
                                valueConfig.setValue(value.toString());
                            } else {
                                throw new UnsupportedChangeException("loadData type of " + columnConfig.getType() + " is not supported.  Please use BOOLEAN, NUMERIC, DATE, or STRING");
                            }
                            value = valueConfig.getValueObject();
                        }
                    }
                    if (columnName == null) {
                        columnName = headers[i];
                    }
                    insertStatement.addColumnValue(columnName, value);
                }
                statements.add(insertStatement);
            }
            return statements.toArray(new SqlStatement[statements.size()]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ColumnConfig getColumnConfig(int index, String header) {
        for (LoadDataColumnConfig config : this.columns) {
            if (config.getIndex() != null && config.getIndex().equals(index)) {
                return config;
            }
            if (config.getHeader() == null || !config.getHeader().equals(header)) continue;
            return config;
        }
        return null;
    }

    @Override
    public String getConfirmationMessage() {
        return "Data loaded from " + this.getFile() + " into " + this.getTableName();
    }

    @Override
    public Element createNode(Document currentChangeLogDOM) {
        Element node = currentChangeLogDOM.createElement("loadData");
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        node.setAttribute("file", this.getFile());
        node.setAttribute("tableName", this.getTableName());
        if (this.getEncoding() != null) {
            node.setAttribute("encoding", this.getEncoding());
        }
        for (LoadDataColumnConfig column : this.columns) {
            node.appendChild(column.createNode(currentChangeLogDOM));
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }

    @Override
    public String getMD5Sum() {
        InputStream stream = null;
        try {
            stream = this.getFileOpener().getResourceAsStream(this.getFile());
            if (stream == null) {
                throw new RuntimeException(this.getFile() + " could not be found");
            }
            String string = MD5Util.computeMD5(stream);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

