/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopChange
extends AbstractChange {
    private String message;

    public StopChange() {
        super("stop", "Stop Execution");
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = StringUtils.trimToNull(message);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        throw new StopChangeException(this.getMessage());
    }

    @Override
    public String getConfirmationMessage() {
        return "Changelog Execution Stopped";
    }

    @Override
    public Node createNode(Document currentChangeLogDOM) {
        Element element = currentChangeLogDOM.createElement(this.getTagName());
        if (this.getMessage() != null) {
            element.setTextContent(this.getMessage());
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }

    public static class StopChangeException
    extends RuntimeException {
        public StopChangeException(String message) {
            super(message);
        }
    }
}

