/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private Map<String, Object> newColumnValues = new HashMap<String, Object>();
    private String whereClause;
    private List<Object> whereParameters = new ArrayList<Object>();

    public UpdateStatement(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public UpdateStatement addNewColumnValue(String columnName, Object newValue) {
        this.newColumnValues.put(columnName, newValue);
        return this;
    }

    public String getWhereClause() {
        return this.whereClause;
    }

    public UpdateStatement setWhereClause(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public void addWhereParameter(Object value) {
        this.whereParameters.add(value);
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    public Map<String, Object> getNewColumnValues() {
        return this.newColumnValues;
    }

    @Override
    public String getSqlStatement(Database database) {
        StringBuffer sql = new StringBuffer("UPDATE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " SET");
        for (String column : this.newColumnValues.keySet()) {
            sql.append(" ").append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), column)).append(" = ");
            sql.append(this.convertToString(this.newColumnValues.get(column), database));
            sql.append(",");
        }
        sql.deleteCharAt(sql.lastIndexOf(","));
        if (this.whereClause != null) {
            String fixedWhereClause = "WHERE " + this.whereClause;
            for (Object param : this.whereParameters) {
                fixedWhereClause = fixedWhereClause.replaceFirst("\\?", this.convertToString(param, database));
            }
            sql.append(" ").append(fixedWhereClause);
        }
        return sql.toString();
    }

    private String convertToString(Object newValue, Database database) {
        String sqlString = newValue == null || newValue.toString().equalsIgnoreCase("NULL") ? "NULL" : (newValue instanceof String && database.shouldQuoteValue((String)newValue) ? "'" + database.escapeStringForDatabase(newValue.toString()) + "'" : (newValue instanceof Date ? database.getDateLiteral((Date)newValue) : (newValue instanceof Boolean ? (((Boolean)newValue).booleanValue() ? database.getTrueBooleanValue() : database.getFalseBooleanValue()) : newValue.toString())));
        return sqlString;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }
}

