/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.sql.SQLException;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class RunningAsPrecondition
implements Precondition {
    private String username = "";

    public void setUsername(String aUserName) {
        this.username = aUserName;
    }

    public String getUsername() {
        return this.username;
    }

    public void check(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        try {
            String loggedusername = database.getConnection().getMetaData().getUserName();
            if (loggedusername.indexOf(64) >= 0) {
                loggedusername = loggedusername.substring(0, loggedusername.indexOf(64));
            }
            if (!this.username.equalsIgnoreCase(loggedusername)) {
                throw new PreconditionFailedException("RunningAs Precondition failed: expected " + this.username + ", was " + loggedusername, changeLog, this);
            }
        }
        catch (SQLException e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
    }

    public String getTagName() {
        return "runningAs";
    }
}

