/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;

public abstract class AbstractSQLChange
extends AbstractChange {
    private boolean stripComments = false;
    private boolean splitStatements = true;
    private String endDelimiter = ";";
    private String sql;

    protected AbstractSQLChange(String tagName, String changeName) {
        super(tagName, changeName);
    }

    public void setStripComments(Boolean stripComments) {
        this.stripComments = stripComments;
    }

    public boolean isStrippingComments() {
        return this.stripComments;
    }

    public void setSplitStatements(Boolean splitStatements) {
        this.splitStatements = splitStatements;
    }

    public boolean isSplittingStatements() {
        return this.splitStatements;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getEndDelimiter() {
        return this.endDelimiter;
    }

    public void setEndDelimiter(String endDelimiter) {
        this.endDelimiter = endDelimiter;
    }

    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.getSql()) == null) {
            throw new InvalidChangeDefinitionException("sql text is required", this);
        }
    }

    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<RawSqlStatement> returnStatements = new ArrayList<RawSqlStatement>();
        String processedSQL = this.isStrippingComments() ? StringUtils.stripComments(this.getSql()) : this.getSql();
        processedSQL = processedSQL.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
        if (this.isSplittingStatements()) {
            String[] statements;
            for (String statement : statements = StringUtils.splitSQL(processedSQL)) {
                returnStatements.add(new RawSqlStatement(statement, this.getEndDelimiter()));
            }
        } else {
            returnStatements.add(new RawSqlStatement(processedSQL, this.getEndDelimiter()));
        }
        return returnStatements.toArray(new SqlStatement[returnStatements.size()]);
    }
}

