/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropDefaultValueChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddDefaultValueStatement;
import liquibase.database.sql.ComputedDateValue;
import liquibase.database.sql.ComputedNumericValue;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddDefaultValueChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String defaultValue;
    private String defaultValueNumeric;
    private String defaultValueDate;
    private Boolean defaultValueBoolean;

    public AddDefaultValueChange() {
        super("addDefaultValue", "Add Default Value");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public void setDefaultValueNumeric(String defaultValueNumeric) {
        this.defaultValueNumeric = defaultValueNumeric;
    }

    public String getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public void setDefaultValueDate(String defaultValueDate) {
        this.defaultValueDate = defaultValueDate;
    }

    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public void setDefaultValueBoolean(Boolean defaultValueBoolean) {
        this.defaultValueBoolean = defaultValueBoolean;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.columnName) == null) {
            throw new InvalidChangeDefinitionException("columnName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        Object defaultValue = null;
        if (this.getDefaultValue() != null) {
            defaultValue = this.getDefaultValue();
        } else if (this.getDefaultValueBoolean() != null) {
            defaultValue = (boolean)this.getDefaultValueBoolean();
        } else if (this.getDefaultValueNumeric() != null) {
            try {
                defaultValue = NumberFormat.getInstance(Locale.US).parse(this.getDefaultValueNumeric());
            }
            catch (ParseException e) {
                defaultValue = new ComputedNumericValue(this.getDefaultValueNumeric());
            }
        } else if (this.getDefaultValueDate() != null) {
            try {
                defaultValue = new ISODateFormat().parse(this.getDefaultValueDate());
            }
            catch (ParseException e) {
                defaultValue = new ComputedDateValue(this.getDefaultValueDate());
            }
        }
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database, defaultValue);
        }
        return new SqlStatement[]{new AddDefaultValueStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.getColumnName(), defaultValue)};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database, Object defaultValue) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                if (column.getName().equals(AddDefaultValueChange.this.getColumnName())) {
                    try {
                        if (AddDefaultValueChange.this.getDefaultValue() != null) {
                            column.setDefaultValue(AddDefaultValueChange.this.getDefaultValue());
                        }
                        if (AddDefaultValueChange.this.getDefaultValueBoolean() != null) {
                            column.setDefaultValueBoolean(AddDefaultValueChange.this.getDefaultValueBoolean());
                        }
                        if (AddDefaultValueChange.this.getDefaultValueDate() != null) {
                            column.setDefaultValueDate(AddDefaultValueChange.this.getDefaultValueDate());
                        }
                        if (AddDefaultValueChange.this.getDefaultValueNumeric() != null) {
                            column.setDefaultValueNumeric(AddDefaultValueChange.this.getDefaultValueNumeric());
                        }
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropDefaultValueChange inverse = new DropDefaultValueChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setColumnName(this.getColumnName());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return "Default value added to " + this.getTableName() + "." + this.getColumnName();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        node.setAttribute("tableName", this.getTableName());
        node.setAttribute("columnName", this.getColumnName());
        if (this.getDefaultValue() != null) {
            node.setAttribute("defaultValue", this.getDefaultValue());
        }
        if (this.getDefaultValueNumeric() != null) {
            node.setAttribute("defaultValueNumeric", this.getDefaultValueNumeric());
        }
        if (this.getDefaultValueDate() != null) {
            node.setAttribute("defaultValueDate", this.getDefaultValueDate());
        }
        if (this.getDefaultValueBoolean() != null) {
            node.setAttribute("defaultValueBoolean", this.getDefaultValueBoolean().toString());
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Column column = new Column();
        Table table = new Table(this.getTableName());
        column.setTable(table);
        column.setName(this.columnName);
        return new HashSet<Comparable>(Arrays.asList(table, column));
    }
}

