/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.HashMap;
import java.util.Map;
import liquibase.DatabaseChangeLog;
import liquibase.FileOpener;
import liquibase.exception.ChangeLogParseException;
import liquibase.parser.sql.SqlChangeLogGenerator;
import liquibase.parser.xml.XMLChangeLogParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeLogParser {
    private Map<String, Object> changeLogParameters;

    public ChangeLogParser() {
        this.changeLogParameters = new HashMap<String, Object>();
    }

    public ChangeLogParser(Map<String, Object> changeLogParameters) {
        this.changeLogParameters = changeLogParameters;
    }

    public DatabaseChangeLog parse(String physicalSqlFileLocation, FileOpener fileOpener) throws ChangeLogParseException {
        if (physicalSqlFileLocation.endsWith("sql")) {
            return new SqlChangeLogGenerator().generate(physicalSqlFileLocation, fileOpener, this.changeLogParameters);
        }
        return new XMLChangeLogParser().parse(physicalSqlFileLocation, fileOpener, this.changeLogParameters);
    }
}

