/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnChange;
import liquibase.change.AddForeignKeyConstraintChange;
import liquibase.change.AddNotNullConstraintChange;
import liquibase.change.AddPrimaryKeyChange;
import liquibase.change.AddUniqueConstraintChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.CreateIndexChange;
import liquibase.change.CreateSequenceChange;
import liquibase.change.CreateTableChange;
import liquibase.change.CreateViewChange;
import liquibase.change.DropColumnChange;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.change.DropIndexChange;
import liquibase.change.DropNotNullConstraintChange;
import liquibase.change.DropPrimaryKeyChange;
import liquibase.change.DropSequenceChange;
import liquibase.change.DropTableChange;
import liquibase.change.DropUniqueConstraintChange;
import liquibase.change.DropViewChange;
import liquibase.change.InsertDataChange;
import liquibase.change.LoadDataChange;
import liquibase.change.LoadDataColumnConfig;
import liquibase.change.ModifyColumnChange;
import liquibase.csv.CSVWriter;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.diff.DiffComparison;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.parser.LiquibaseSchemaResolver;
import liquibase.parser.xml.XMLChangeLogParser;
import liquibase.util.SqlUtil;
import liquibase.util.StringUtils;
import liquibase.xml.DefaultXmlWriter;
import liquibase.xml.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiffResult {
    private Long baseId = new Date().getTime();
    private int changeNumber = 1;
    private Database baseDatabase;
    private Database targetDatabase;
    private DatabaseSnapshot baseSnapshot;
    private DatabaseSnapshot targetSnapshot;
    private DiffComparison productName;
    private DiffComparison productVersion;
    private SortedSet<Table> missingTables = new TreeSet<Table>();
    private SortedSet<Table> unexpectedTables = new TreeSet<Table>();
    private SortedSet<View> missingViews = new TreeSet<View>();
    private SortedSet<View> unexpectedViews = new TreeSet<View>();
    private SortedSet<Column> missingColumns = new TreeSet<Column>();
    private SortedSet<Column> unexpectedColumns = new TreeSet<Column>();
    private SortedSet<Column> changedColumns = new TreeSet<Column>();
    private SortedSet<ForeignKey> missingForeignKeys = new TreeSet<ForeignKey>();
    private SortedSet<ForeignKey> unexpectedForeignKeys = new TreeSet<ForeignKey>();
    private SortedSet<Index> missingIndexes = new TreeSet<Index>();
    private SortedSet<Index> unexpectedIndexes = new TreeSet<Index>();
    private SortedSet<PrimaryKey> missingPrimaryKeys = new TreeSet<PrimaryKey>();
    private SortedSet<PrimaryKey> unexpectedPrimaryKeys = new TreeSet<PrimaryKey>();
    private SortedSet<UniqueConstraint> missingUniqueConstraints = new TreeSet<UniqueConstraint>();
    private SortedSet<UniqueConstraint> unexpectedUniqueConstraints = new TreeSet<UniqueConstraint>();
    private SortedSet<Sequence> missingSequences = new TreeSet<Sequence>();
    private SortedSet<Sequence> unexpectedSequences = new TreeSet<Sequence>();
    private boolean diffData = false;
    private String dataDir = null;
    private String changeSetContext;
    private String changeSetAuthor;

    public DiffResult(DatabaseSnapshot baseDatabase, DatabaseSnapshot targetDatabase) {
        this.baseDatabase = baseDatabase.getDatabase();
        this.targetDatabase = targetDatabase.getDatabase();
        this.baseSnapshot = baseDatabase;
        this.targetSnapshot = targetDatabase;
    }

    public DiffComparison getProductName() {
        return this.productName;
    }

    public void setProductName(DiffComparison productName) {
        this.productName = productName;
    }

    public DiffComparison getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(DiffComparison product) {
        this.productVersion = product;
    }

    public void addMissingTable(Table table) {
        this.missingTables.add(table);
    }

    public SortedSet<Table> getMissingTables() {
        return this.missingTables;
    }

    public void addUnexpectedTable(Table table) {
        this.unexpectedTables.add(table);
    }

    public SortedSet<Table> getUnexpectedTables() {
        return this.unexpectedTables;
    }

    public void addMissingView(View viewName) {
        this.missingViews.add(viewName);
    }

    public SortedSet<View> getMissingViews() {
        return this.missingViews;
    }

    public void addUnexpectedView(View viewName) {
        this.unexpectedViews.add(viewName);
    }

    public SortedSet<View> getUnexpectedViews() {
        return this.unexpectedViews;
    }

    public void addMissingColumn(Column columnName) {
        this.missingColumns.add(columnName);
    }

    public SortedSet<Column> getMissingColumns() {
        return this.missingColumns;
    }

    public void addUnexpectedColumn(Column columnName) {
        this.unexpectedColumns.add(columnName);
    }

    public SortedSet<Column> getUnexpectedColumns() {
        return this.unexpectedColumns;
    }

    public void addChangedColumn(Column columnName) {
        this.changedColumns.add(columnName);
    }

    public SortedSet<Column> getChangedColumns() {
        return this.changedColumns;
    }

    public void addMissingForeignKey(ForeignKey fkName) {
        this.missingForeignKeys.add(fkName);
    }

    public SortedSet<ForeignKey> getMissingForeignKeys() {
        return this.missingForeignKeys;
    }

    public void addUnexpectedForeignKey(ForeignKey fkName) {
        this.unexpectedForeignKeys.add(fkName);
    }

    public SortedSet<ForeignKey> getUnexpectedForeignKeys() {
        return this.unexpectedForeignKeys;
    }

    public void addMissingIndex(Index fkName) {
        this.missingIndexes.add(fkName);
    }

    public SortedSet<Index> getMissingIndexes() {
        return this.missingIndexes;
    }

    public void addUnexpectedIndex(Index fkName) {
        this.unexpectedIndexes.add(fkName);
    }

    public SortedSet<Index> getUnexpectedIndexes() {
        return this.unexpectedIndexes;
    }

    public void addMissingPrimaryKey(PrimaryKey primaryKey) {
        this.missingPrimaryKeys.add(primaryKey);
    }

    public SortedSet<PrimaryKey> getMissingPrimaryKeys() {
        return this.missingPrimaryKeys;
    }

    public void addUnexpectedPrimaryKey(PrimaryKey primaryKey) {
        this.unexpectedPrimaryKeys.add(primaryKey);
    }

    public SortedSet<PrimaryKey> getUnexpectedPrimaryKeys() {
        return this.unexpectedPrimaryKeys;
    }

    public void addMissingSequence(Sequence sequence) {
        this.missingSequences.add(sequence);
    }

    public SortedSet<Sequence> getMissingSequences() {
        return this.missingSequences;
    }

    public void addUnexpectedSequence(Sequence sequence) {
        this.unexpectedSequences.add(sequence);
    }

    public SortedSet<Sequence> getUnexpectedSequences() {
        return this.unexpectedSequences;
    }

    public void addMissingUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.missingUniqueConstraints.add(uniqueConstraint);
    }

    public SortedSet<UniqueConstraint> getMissingUniqueConstraints() {
        return this.missingUniqueConstraints;
    }

    public void addUnexpectedUniqueConstraint(UniqueConstraint uniqueConstraint) {
        this.unexpectedUniqueConstraints.add(uniqueConstraint);
    }

    public SortedSet<UniqueConstraint> getUnexpectedUniqueConstraints() {
        return this.unexpectedUniqueConstraints;
    }

    public boolean shouldDiffData() {
        return this.diffData;
    }

    public void setDiffData(boolean diffData) {
        this.diffData = diffData;
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public String getChangeSetContext() {
        return this.changeSetContext;
    }

    public void setChangeSetContext(String changeSetContext) {
        this.changeSetContext = changeSetContext;
    }

    public void printResult(PrintStream out) throws JDBCException {
        out.println("Base Database: " + this.targetDatabase.getConnectionUsername() + " " + this.targetDatabase.getConnectionURL());
        out.println("Target Database: " + this.baseDatabase.getConnectionUsername() + " " + this.baseDatabase.getConnectionURL());
        this.printComparision("Product Name", this.productName, out);
        this.printComparision("Product Version", this.productVersion, out);
        this.printSetComparison("Missing Tables", this.getMissingTables(), out);
        this.printSetComparison("Unexpected Tables", this.getUnexpectedTables(), out);
        this.printSetComparison("Missing Views", this.getMissingViews(), out);
        this.printSetComparison("Unexpected Views", this.getUnexpectedViews(), out);
        this.printSetComparison("Missing Columns", this.getMissingColumns(), out);
        this.printSetComparison("Unexpected Columns", this.getUnexpectedColumns(), out);
        this.printColumnComparison(this.getChangedColumns(), out);
        this.printSetComparison("Missing Foreign Keys", this.getMissingForeignKeys(), out);
        this.printSetComparison("Unexpected Foreign Keys", this.getUnexpectedForeignKeys(), out);
        this.printSetComparison("Missing Primary Keys", this.getMissingPrimaryKeys(), out);
        this.printSetComparison("Unexpected Primary Keys", this.getUnexpectedPrimaryKeys(), out);
        this.printSetComparison("Missing Unique Constraints", this.getMissingUniqueConstraints(), out);
        this.printSetComparison("Unexpected Unique Constraints", this.getUnexpectedUniqueConstraints(), out);
        this.printSetComparison("Missing Indexes", this.getMissingIndexes(), out);
        this.printSetComparison("Unexpected Indexes", this.getUnexpectedIndexes(), out);
        this.printSetComparison("Missing Sequences", this.getMissingSequences(), out);
        this.printSetComparison("Unexpected Sequences", this.getUnexpectedSequences(), out);
    }

    private void printSetComparison(String title, SortedSet<?> objects, PrintStream out) {
        out.print(title + ": ");
        if (objects.size() == 0) {
            out.println("NONE");
        } else {
            out.println();
            for (Object object : objects) {
                out.println("     " + object);
            }
        }
    }

    private void printColumnComparison(SortedSet<Column> changedColumns, PrintStream out) {
        out.print("Changed Columns: ");
        if (changedColumns.size() == 0) {
            out.println("NONE");
        } else {
            out.println();
            for (Column column : changedColumns) {
                out.println("     " + column);
                Column baseColumn = this.baseSnapshot.getColumn(column);
                if (baseColumn == null) continue;
                if (baseColumn.isDataTypeDifferent(column)) {
                    out.println("           from " + baseColumn.getDataTypeString(this.baseDatabase) + " to " + this.targetSnapshot.getColumn(column).getDataTypeString(this.targetDatabase));
                }
                if (!baseColumn.isNullabilityDifferent(column)) continue;
                Boolean nowNullable = this.targetSnapshot.getColumn(column).isNullable();
                if (nowNullable == null) {
                    nowNullable = Boolean.TRUE;
                }
                if (nowNullable.booleanValue()) {
                    out.println("           now nullable");
                    continue;
                }
                out.println("           now not null");
            }
        }
    }

    private void printComparision(String title, DiffComparison comparison, PrintStream out) {
        out.print(title + ":");
        if (comparison.areTheSame()) {
            out.println(" EQUAL");
        } else {
            out.println();
            out.println("     Base:   '" + comparison.getBaseVersion() + "'");
            out.println("     Target: '" + comparison.getTargetVersion() + "'");
        }
    }

    public void printChangeLog(String changeLogFile, Database targetDatabase) throws ParserConfigurationException, IOException, JDBCException {
        this.printChangeLog(changeLogFile, targetDatabase, (XmlWriter)new DefaultXmlWriter());
    }

    public void printChangeLog(PrintStream out, Database targetDatabase) throws ParserConfigurationException, IOException, JDBCException {
        this.printChangeLog(out, targetDatabase, (XmlWriter)new DefaultXmlWriter());
    }

    public void printChangeLog(String changeLogFile, Database targetDatabase, XmlWriter xmlWriter) throws ParserConfigurationException, IOException, JDBCException {
        File file = new File(changeLogFile);
        if (!file.exists()) {
            LogFactory.getLogger().info(file + " does not exist, creating");
            FileOutputStream stream = new FileOutputStream(file);
            this.printChangeLog(new PrintStream(stream), targetDatabase, xmlWriter);
            stream.close();
        } else {
            String line;
            LogFactory.getLogger().info(file + " exists, appending");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.printChangeLog(new PrintStream(out), targetDatabase, xmlWriter);
            String xml = new String(out.toByteArray());
            xml = xml.replaceFirst("(?ms).*<databaseChangeLog[^>]*>", "");
            xml = xml.replaceFirst("</databaseChangeLog>", "");
            xml = xml.trim();
            String lineSeparator = System.getProperty("line.separator");
            BufferedReader fileReader = new BufferedReader(new FileReader(file));
            long offset = 0L;
            while ((line = fileReader.readLine()) != null) {
                int index = line.indexOf("</databaseChangeLog>");
                if (index >= 0) {
                    offset += (long)index;
                    continue;
                }
                offset += (long)line.getBytes().length;
                offset += (long)lineSeparator.getBytes().length;
            }
            fileReader.close();
            fileReader = new BufferedReader(new FileReader(file));
            fileReader.skip(offset);
            fileReader.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.seek(offset);
            randomAccessFile.writeBytes("    " + xml + lineSeparator);
            randomAccessFile.writeBytes("</databaseChangeLog>" + lineSeparator);
            randomAccessFile.close();
        }
    }

    public void printChangeLog(PrintStream out, Database targetDatabase, XmlWriter xmlWriter) throws ParserConfigurationException, IOException, JDBCException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = factory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new LiquibaseSchemaResolver());
        Document doc = documentBuilder.newDocument();
        Element changeLogElement = doc.createElement("databaseChangeLog");
        changeLogElement.setAttribute("xmlns", "http://www.liquibase.org/xml/ns/dbchangelog/" + XMLChangeLogParser.getSchemaVersion());
        changeLogElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        changeLogElement.setAttribute("xsi:schemaLocation", "http://www.liquibase.org/xml/ns/dbchangelog/" + XMLChangeLogParser.getSchemaVersion() + " http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-" + XMLChangeLogParser.getSchemaVersion() + ".xsd");
        doc.appendChild(changeLogElement);
        ArrayList<Change> changes = new ArrayList<Change>();
        this.addUnexpectedViewChanges(changes);
        this.addMissingTableChanges(changes, targetDatabase);
        this.addMissingColumnChanges(changes, targetDatabase);
        this.addChangedColumnChanges(changes);
        this.addMissingPrimaryKeyChanges(changes);
        this.addUnexpectedPrimaryKeyChanges(changes);
        this.addMissingUniqueConstraintChanges(changes);
        this.addUnexpectedUniqueConstraintChanges(changes);
        this.addMissingIndexChanges(changes);
        this.addUnexpectedIndexChanges(changes);
        if (this.diffData) {
            this.addInsertDataChanges(changes, this.dataDir);
        }
        this.addMissingForeignKeyChanges(changes);
        this.addUnexpectedForeignKeyChanges(changes);
        this.addUnexpectedColumnChanges(changes);
        this.addMissingSequenceChanges(changes);
        this.addUnexpectedSequenceChanges(changes);
        this.addMissingViewChanges(changes);
        this.addUnexpectedTableChanges(changes);
        for (Change change : changes) {
            Element changeSet = doc.createElement("changeSet");
            changeSet.setAttribute("author", this.getChangeSetAuthor());
            changeSet.setAttribute("id", this.generateId());
            if (this.getChangeSetContext() != null) {
                changeSet.setAttribute("context", this.getChangeSetContext());
            }
            changeSet.appendChild(change.createNode(doc));
            doc.getDocumentElement().appendChild(changeSet);
        }
        xmlWriter.write(doc, out);
        out.flush();
    }

    private String getChangeSetAuthor() {
        if (this.changeSetAuthor != null) {
            return this.changeSetAuthor;
        }
        String author = System.getProperty("user.name");
        if (StringUtils.trimToNull(author) == null) {
            return "diff-generated";
        }
        return author + " (generated)";
    }

    public void setChangeSetAuthor(String changeSetAuthor) {
        this.changeSetAuthor = changeSetAuthor;
    }

    private String generateId() {
        return this.baseId.toString() + "-" + this.changeNumber++;
    }

    private void addUnexpectedIndexChanges(List<Change> changes) {
        for (Index index : this.getUnexpectedIndexes()) {
            DropIndexChange change = new DropIndexChange();
            change.setTableName(index.getTable().getName());
            change.setSchemaName(index.getTable().getSchema());
            change.setIndexName(index.getName());
            changes.add(change);
        }
    }

    private void addMissingIndexChanges(List<Change> changes) {
        for (Index index : this.getMissingIndexes()) {
            CreateIndexChange change = new CreateIndexChange();
            change.setTableName(index.getTable().getName());
            change.setSchemaName(index.getTable().getSchema());
            change.setIndexName(index.getName());
            change.setUnique(index.isUnique());
            for (String columnName : index.getColumns()) {
                ColumnConfig column = new ColumnConfig();
                column.setName(columnName);
                change.addColumn(column);
            }
            changes.add(change);
        }
    }

    private void addUnexpectedPrimaryKeyChanges(List<Change> changes) {
        for (PrimaryKey pk : this.getUnexpectedPrimaryKeys()) {
            if (this.getUnexpectedTables().contains(pk.getTable())) continue;
            DropPrimaryKeyChange change = new DropPrimaryKeyChange();
            change.setTableName(pk.getTable().getName());
            change.setSchemaName(pk.getTable().getSchema());
            change.setConstraintName(pk.getName());
            changes.add(change);
        }
    }

    private void addMissingPrimaryKeyChanges(List<Change> changes) {
        for (PrimaryKey pk : this.getMissingPrimaryKeys()) {
            AddPrimaryKeyChange change = new AddPrimaryKeyChange();
            change.setTableName(pk.getTable().getName());
            change.setSchemaName(pk.getTable().getSchema());
            change.setConstraintName(pk.getName());
            change.setColumnNames(pk.getColumnNames());
            changes.add(change);
        }
    }

    private void addUnexpectedUniqueConstraintChanges(List<Change> changes) {
        for (UniqueConstraint uc : this.getUnexpectedUniqueConstraints()) {
            if (this.getUnexpectedTables().contains(uc.getTable())) continue;
            DropUniqueConstraintChange change = new DropUniqueConstraintChange();
            change.setTableName(uc.getTable().getName());
            change.setSchemaName(uc.getTable().getSchema());
            change.setConstraintName(uc.getName());
            changes.add(change);
        }
    }

    private void addMissingUniqueConstraintChanges(List<Change> changes) {
        for (UniqueConstraint uc : this.getMissingUniqueConstraints()) {
            AddUniqueConstraintChange change = new AddUniqueConstraintChange();
            change.setTableName(uc.getTable().getName());
            change.setSchemaName(uc.getTable().getSchema());
            change.setConstraintName(uc.getName());
            change.setColumnNames(uc.getColumnNames());
            changes.add(change);
        }
    }

    private void addUnexpectedForeignKeyChanges(List<Change> changes) {
        for (ForeignKey fk : this.getUnexpectedForeignKeys()) {
            DropForeignKeyConstraintChange change = new DropForeignKeyConstraintChange();
            change.setConstraintName(fk.getName());
            change.setBaseTableName(fk.getForeignKeyTable().getName());
            change.setBaseTableSchemaName(fk.getForeignKeyTable().getSchema());
            changes.add(change);
        }
    }

    private void addMissingForeignKeyChanges(List<Change> changes) {
        for (ForeignKey fk : this.getMissingForeignKeys()) {
            AddForeignKeyConstraintChange change = new AddForeignKeyConstraintChange();
            change.setConstraintName(fk.getName());
            change.setReferencedTableName(fk.getPrimaryKeyTable().getName());
            change.setReferencedTableSchemaName(fk.getPrimaryKeyTable().getSchema());
            change.setReferencedColumnNames(fk.getPrimaryKeyColumns());
            change.setBaseTableName(fk.getForeignKeyTable().getName());
            change.setBaseTableSchemaName(fk.getForeignKeyTable().getSchema());
            change.setBaseColumnNames(fk.getForeignKeyColumns());
            change.setDeferrable(fk.isDeferrable());
            change.setInitiallyDeferred(fk.isInitiallyDeferred());
            change.setUpdateRule(fk.getUpdateRule());
            change.setDeleteRule(fk.getDeleteRule());
            changes.add(change);
        }
    }

    private void addUnexpectedSequenceChanges(List<Change> changes) {
        for (Sequence sequence : this.getUnexpectedSequences()) {
            DropSequenceChange change = new DropSequenceChange();
            change.setSequenceName(sequence.getName());
            change.setSchemaName(sequence.getSchema());
            changes.add(change);
        }
    }

    private void addMissingSequenceChanges(List<Change> changes) {
        for (Sequence sequence : this.getMissingSequences()) {
            CreateSequenceChange change = new CreateSequenceChange();
            change.setSequenceName(sequence.getName());
            change.setSchemaName(sequence.getSchema());
            changes.add(change);
        }
    }

    private void addUnexpectedColumnChanges(List<Change> changes) {
        for (Column column : this.getUnexpectedColumns()) {
            if (!this.shouldModifyColumn(column)) continue;
            DropColumnChange change = new DropColumnChange();
            change.setTableName(column.getTable().getName());
            change.setSchemaName(column.getTable().getSchema());
            change.setColumnName(column.getName());
            changes.add(change);
        }
    }

    private void addMissingViewChanges(List<Change> changes) {
        for (View view : this.getMissingViews()) {
            CreateViewChange change = new CreateViewChange();
            change.setViewName(view.getName());
            change.setSchemaName(view.getSchema());
            String selectQuery = view.getDefinition();
            if (selectQuery == null) {
                selectQuery = "COULD NOT DETERMINE VIEW QUERY";
            }
            change.setSelectQuery(selectQuery);
            changes.add(change);
        }
    }

    private void addChangedColumnChanges(List<Change> changes) {
        for (Column column : this.getChangedColumns()) {
            if (!this.shouldModifyColumn(column)) continue;
            boolean foundDifference = false;
            Column baseColumn = this.baseSnapshot.getColumn(column);
            if (column.isDataTypeDifferent(baseColumn)) {
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(column.getName());
                columnConfig.setType(baseColumn.getDataTypeString(this.targetDatabase));
                ModifyColumnChange change = new ModifyColumnChange();
                change.setTableName(column.getTable().getName());
                change.setSchemaName(column.getTable().getSchema());
                change.addColumn(columnConfig);
                changes.add(change);
                foundDifference = true;
            }
            if (column.isNullabilityDifferent(baseColumn)) {
                AbstractChange change;
                if (baseColumn.isNullable() == null || baseColumn.isNullable().booleanValue()) {
                    change = new DropNotNullConstraintChange();
                    ((DropNotNullConstraintChange)change).setTableName(column.getTable().getName());
                    ((DropNotNullConstraintChange)change).setSchemaName(column.getTable().getSchema());
                    ((DropNotNullConstraintChange)change).setColumnName(column.getName());
                    ((DropNotNullConstraintChange)change).setColumnDataType(baseColumn.getDataTypeString(this.targetDatabase));
                    changes.add(change);
                    foundDifference = true;
                } else {
                    change = new AddNotNullConstraintChange();
                    ((AddNotNullConstraintChange)change).setTableName(column.getTable().getName());
                    ((AddNotNullConstraintChange)change).setSchemaName(column.getTable().getSchema());
                    ((AddNotNullConstraintChange)change).setColumnName(column.getName());
                    ((AddNotNullConstraintChange)change).setColumnDataType(baseColumn.getDataTypeString(this.targetDatabase));
                    changes.add(change);
                    foundDifference = true;
                }
            }
            if (foundDifference) continue;
            throw new RuntimeException("Unknown difference");
        }
    }

    private boolean shouldModifyColumn(Column column) {
        return column.getView() == null && !this.baseDatabase.isLiquibaseTable(column.getTable().getName());
    }

    private void addUnexpectedViewChanges(List<Change> changes) {
        for (View view : this.getUnexpectedViews()) {
            DropViewChange change = new DropViewChange();
            change.setViewName(view.getName());
            change.setSchemaName(view.getSchema());
            changes.add(change);
        }
    }

    private void addMissingColumnChanges(List<Change> changes, Database database) {
        for (Column column : this.getMissingColumns()) {
            if (!this.shouldModifyColumn(column)) continue;
            AddColumnChange change = new AddColumnChange();
            change.setTableName(column.getTable().getName());
            change.setSchemaName(column.getTable().getSchema());
            ColumnConfig columnConfig = new ColumnConfig();
            columnConfig.setName(column.getName());
            String dataType = column.getDataTypeString(database);
            columnConfig.setType(dataType);
            String defaultValueString = database.convertJavaObjectToString(column.getDefaultValue());
            if (defaultValueString != null) {
                defaultValueString = defaultValueString.replaceFirst("'", "").replaceAll("'$", "");
            }
            columnConfig.setDefaultValue(defaultValueString);
            if (column.getRemarks() != null) {
                columnConfig.setRemarks(column.getRemarks());
            }
            if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                ConstraintsConfig constraintsConfig = columnConfig.getConstraints();
                if (constraintsConfig == null) {
                    constraintsConfig = new ConstraintsConfig();
                    columnConfig.setConstraints(constraintsConfig);
                }
                constraintsConfig.setNullable(false);
            }
            change.addColumn(columnConfig);
            changes.add(change);
        }
    }

    private void addMissingTableChanges(List<Change> changes, Database database) {
        for (Table missingTable : this.getMissingTables()) {
            if (this.baseDatabase.isLiquibaseTable(missingTable.getName())) continue;
            CreateTableChange change = new CreateTableChange();
            change.setTableName(missingTable.getName());
            change.setSchemaName(missingTable.getSchema());
            if (missingTable.getRemarks() != null) {
                change.setRemarks(missingTable.getRemarks());
            }
            for (Column column : missingTable.getColumns()) {
                Object defaultValue;
                ColumnConfig columnConfig = new ColumnConfig();
                columnConfig.setName(column.getName());
                columnConfig.setType(column.getDataTypeString(database));
                ConstraintsConfig constraintsConfig = null;
                if (column.isPrimaryKey()) {
                    PrimaryKey primaryKey = null;
                    for (PrimaryKey pk : this.getMissingPrimaryKeys()) {
                        if (!pk.getTable().getName().equalsIgnoreCase(missingTable.getName())) continue;
                        primaryKey = pk;
                    }
                    if (primaryKey == null || primaryKey.getColumnNamesAsList().size() == 1) {
                        constraintsConfig = new ConstraintsConfig();
                        constraintsConfig.setPrimaryKey(true);
                        if (primaryKey != null) {
                            constraintsConfig.setPrimaryKeyName(primaryKey.getName());
                            this.getMissingPrimaryKeys().remove(primaryKey);
                        }
                    }
                }
                if (column.isAutoIncrement()) {
                    columnConfig.setAutoIncrement(true);
                }
                if (column.isNullable() != null && !column.isNullable().booleanValue()) {
                    if (constraintsConfig == null) {
                        constraintsConfig = new ConstraintsConfig();
                    }
                    constraintsConfig.setNullable(false);
                }
                if (constraintsConfig != null) {
                    columnConfig.setConstraints(constraintsConfig);
                }
                if ((defaultValue = column.getDefaultValue()) != null && !column.isAutoIncrement()) {
                    if (defaultValue instanceof Date) {
                        columnConfig.setDefaultValueDate((Date)defaultValue);
                    } else if (defaultValue instanceof Boolean) {
                        columnConfig.setDefaultValueBoolean((Boolean)defaultValue);
                    } else if (defaultValue instanceof Number) {
                        columnConfig.setDefaultValueNumeric((Number)defaultValue);
                    } else {
                        columnConfig.setDefaultValue(defaultValue.toString());
                    }
                }
                if (column.getRemarks() != null) {
                    columnConfig.setRemarks(column.getRemarks());
                }
                change.addColumn(columnConfig);
            }
            changes.add(change);
        }
    }

    private void addUnexpectedTableChanges(List<Change> changes) {
        for (Table unexpectedTable : this.getUnexpectedTables()) {
            DropTableChange change = new DropTableChange();
            change.setTableName(unexpectedTable.getName());
            change.setSchemaName(unexpectedTable.getSchema());
            changes.add(change);
        }
    }

    private void addInsertDataChanges(List<Change> changes, String dataDir) throws JDBCException, IOException {
        try {
            String schema = this.baseSnapshot.getSchema();
            Statement stmt = this.baseSnapshot.getDatabase().getConnection().createStatement();
            for (Table table : this.baseSnapshot.getTables()) {
                ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.baseSnapshot.getDatabase().escapeTableName(schema, table.getName()));
                ResultSetMetaData columnData = rs.getMetaData();
                int columnCount = columnData.getColumnCount();
                if (dataDir != null) {
                    File parentDir;
                    String fileName = table.getName() + ".csv";
                    if (dataDir != null) {
                        fileName = dataDir + "/" + fileName;
                    }
                    if (!(parentDir = new File(dataDir)).exists()) {
                        parentDir.mkdirs();
                    }
                    if (!parentDir.isDirectory()) {
                        throw new RuntimeException(parentDir + " is not a directory");
                    }
                    CSVWriter outputFile = new CSVWriter(new FileWriter(fileName));
                    outputFile.writeAll(rs, true);
                    outputFile.flush();
                    outputFile.close();
                    LoadDataChange change = new LoadDataChange();
                    change.setFile(fileName);
                    change.setEncoding("UTF-8");
                    change.setSchemaName(schema);
                    change.setTableName(table.getName());
                    for (int col = 1; col <= columnCount; ++col) {
                        String colName = columnData.getColumnName(col);
                        int dataType = columnData.getColumnType(col);
                        String typeString = "STRING";
                        if (SqlUtil.isNumeric(dataType)) {
                            typeString = "NUMERIC";
                        } else if (SqlUtil.isBoolean(dataType)) {
                            typeString = "BOOLEAN";
                        } else if (SqlUtil.isDate(dataType)) {
                            typeString = "DATE";
                        }
                        LoadDataColumnConfig columnConfig = new LoadDataColumnConfig();
                        columnConfig.setHeader(colName);
                        columnConfig.setType(typeString);
                        change.addColumn(columnConfig);
                    }
                    changes.add(change);
                    continue;
                }
                while (rs.next()) {
                    InsertDataChange change = new InsertDataChange();
                    change.setSchemaName(schema);
                    change.setTableName(table.getName());
                    for (int col = 1; col <= columnCount; ++col) {
                        ColumnConfig column = new ColumnConfig();
                        column.setName(columnData.getColumnName(col));
                        int dataType = columnData.getColumnType(col);
                        if (SqlUtil.isNumeric(dataType)) {
                            String columnValue = rs.getString(col);
                            if (columnValue == null) {
                                column.setValueNumeric((Number)null);
                            } else if (dataType == 8 || dataType == 2 || dataType == 3) {
                                column.setValueNumeric(new Double(columnValue));
                            } else if (dataType == 6 || dataType == 7) {
                                column.setValueNumeric(new Float(columnValue));
                            } else {
                                column.setValueNumeric(new Integer(columnValue));
                            }
                        } else if (SqlUtil.isBoolean(dataType)) {
                            column.setValueBoolean(rs.getBoolean(col));
                        } else if (SqlUtil.isDate(dataType)) {
                            column.setValueDate(rs.getDate(col));
                        } else {
                            column.setValue(rs.getString(col));
                        }
                        change.addColumn(column);
                    }
                    changes.add(change);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

