/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.Liquibase;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.dbdoc.HTMLWriter;
import liquibase.exception.MigrationFailedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PendingSQLWriter
extends HTMLWriter {
    public PendingSQLWriter(File rootOutputDir, Database database) {
        super(new File(rootOutputDir, "pending"), database);
    }

    @Override
    protected String createTitle(Object object) {
        return "Pending SQL";
    }

    protected void writeBody(FileWriter fileWriter, Object object, List<Change> ranChanges, List<Change> changesToRun, Liquibase liquibase) throws IOException {
        if (changesToRun.size() == 0) {
            fileWriter.append("<b>NONE</b>");
        }
        fileWriter.append("<code><pre>");
        ChangeSet lastRunChangeSet = null;
        for (Change change : changesToRun) {
            ChangeSet thisChangeSet = change.getChangeSet();
            if (thisChangeSet.equals(lastRunChangeSet)) continue;
            lastRunChangeSet = thisChangeSet;
            String anchor = thisChangeSet.toString(false).replaceAll("\\W", "_");
            fileWriter.append("<a name='").append(anchor).append("'/>");
            try {
                thisChangeSet.execute(liquibase.getDatabase());
            }
            catch (MigrationFailedException e) {
                fileWriter.append("EXECUTION ERROR: ").append(change.getChangeName()).append(": ").append(e.getMessage()).append("\n\n");
            }
        }
        fileWriter.append("</pre></code>");
    }

    @Override
    protected void writeCustomHTML(FileWriter fileWriter, Object object, List<Change> changes, Database database) throws IOException {
    }
}

