/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DataType;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.MSSQLDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSSQLDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "Microsoft SQL Server";
    protected Set<String> systemTablesAndViews = new HashSet<String>();
    private static final DataType DATETIME_TYPE = new DataType("DATETIME", false);
    private static final DataType DATE_TYPE = new DataType("SMALLDATETIME", false);
    private static final DataType BOOLEAN_TYPE = new DataType("BIT", false);
    private static final DataType CURRENCY_TYPE = new DataType("MONEY", false);
    private static final DataType UUID_TYPE = new DataType("UNIQUEIDENTIFIER", false);
    private static final DataType CLOB_TYPE = new DataType("TEXT", true);
    private static final DataType BLOB_TYPE = new DataType("IMAGE", true);

    @Override
    public String getProductName() {
        return "Microsoft SQL";
    }

    @Override
    public String getTypeName() {
        return "mssql";
    }

    public MSSQLDatabase() {
        this.systemTablesAndViews.add("syscolumns");
        this.systemTablesAndViews.add("syscomments");
        this.systemTablesAndViews.add("sysdepends");
        this.systemTablesAndViews.add("sysfilegroups");
        this.systemTablesAndViews.add("sysfiles");
        this.systemTablesAndViews.add("sysfiles1");
        this.systemTablesAndViews.add("sysforeignkeys");
        this.systemTablesAndViews.add("sysfulltextcatalogs");
        this.systemTablesAndViews.add("sysfulltextnotify");
        this.systemTablesAndViews.add("sysindexes");
        this.systemTablesAndViews.add("sysindexkeys");
        this.systemTablesAndViews.add("sysmembers");
        this.systemTablesAndViews.add("sysobjects");
        this.systemTablesAndViews.add("syspermissions");
        this.systemTablesAndViews.add("sysproperties");
        this.systemTablesAndViews.add("sysprotects");
        this.systemTablesAndViews.add("sysreferences");
        this.systemTablesAndViews.add("systypes");
        this.systemTablesAndViews.add("sysusers");
        this.systemTablesAndViews.add("syssegments");
        this.systemTablesAndViews.add("sysconstraints");
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sqlserver")) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (url.startsWith("jdbc:jtds:sqlserver")) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        return null;
    }

    @Override
    public DataType getDateTimeType() {
        return DATETIME_TYPE;
    }

    @Override
    public DataType getTimeType() {
        return DATETIME_TYPE;
    }

    @Override
    public DataType getDateType() {
        return DATE_TYPE;
    }

    @Override
    public DataType getBooleanType() {
        return BOOLEAN_TYPE;
    }

    @Override
    public DataType getCurrencyType() {
        return CURRENCY_TYPE;
    }

    @Override
    public DataType getUUIDType() {
        return UUID_TYPE;
    }

    @Override
    public DataType getClobType() {
        return CLOB_TYPE;
    }

    @Override
    public DataType getBlobType() {
        return BLOB_TYPE;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "GETDATE()";
    }

    @Override
    public String getAutoIncrementClause() {
        return "IDENTITY";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return null;
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        try {
            return this.getConnection().getCatalog();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getConcatSql(String ... values) {
        StringBuffer returnString = new StringBuffer();
        for (String value : values) {
            returnString.append(value).append(" + ");
        }
        return returnString.toString().replaceFirst(" \\+ $", "");
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        return super.isSystemTable(catalogName, schemaName, tableName) || schemaName.equals("sys");
    }

    @Override
    public boolean isSystemView(String catalogName, String schemaName, String viewName) {
        return super.isSystemView(catalogName, schemaName, viewName) || schemaName.equals("sys");
    }

    public String generateDefaultConstraintName(String tableName, String columnName) {
        return "DF_" + tableName + "_" + columnName;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object defaultValue, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (defaultValue == null) {
            return null;
        }
        if (defaultValue instanceof String) {
            if (((String)defaultValue).startsWith("('")) {
                defaultValue = ((String)defaultValue).replaceFirst("^\\('", "").replaceFirst("'\\)$", "");
            } else if (((String)defaultValue).startsWith("((")) {
                defaultValue = ((String)defaultValue).replaceFirst("^\\(\\(", "").replaceFirst("\\)\\)$", "");
            }
        }
        defaultValue = super.convertDatabaseValueToJavaObject(defaultValue, dataType, columnSize, decimalDigits);
        return defaultValue;
    }

    @Override
    public String escapeTableName(String schemaName, String tableName) {
        if (schemaName == null) {
            return "[" + tableName + "]";
        }
        return "[" + schemaName + "].[" + tableName + "]";
    }

    @Override
    public String escapeConstraintName(String constraintName) {
        if (constraintName == null) {
            return null;
        }
        return "[" + constraintName + "]";
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws JDBCException {
        return this.getDefaultCatalogName();
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws JDBCException {
        if (requestedSchema == null) {
            return "dbo";
        }
        return requestedSchema;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String viewName) throws JDBCException {
        String sql = "select view_definition from INFORMATION_SCHEMA.VIEWS where upper(table_name)='" + viewName.toUpperCase() + "'";
        sql = sql + " and table_schema='" + this.convertRequestedSchemaToSchema(schemaName) + "'";
        sql = sql + " and table_catalog='" + this.getDefaultCatalogName() + "'";
        return new RawSqlStatement(sql);
    }

    @Override
    public String getColumnType(String columnType, Boolean autoIncrement) {
        String type = super.getColumnType(columnType, autoIncrement);
        if (autoIncrement != null && autoIncrement.booleanValue()) {
            type = type.replaceFirst(" identity$", "");
        }
        return type;
    }

    @Override
    public String getDateLiteral(String isoDate) {
        return super.getDateLiteral(isoDate).replace(' ', 'T');
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new MSSQLDatabaseSnapshot(this, statusListeners, schema);
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    @Override
    public String escapeColumnName(String schemaName, String tableName, String columnName) {
        return "[" + columnName + "]";
    }
}

