/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.ArrayList;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.ValidationFailedException;
import liquibase.parser.ChangeLogIterator;
import liquibase.parser.filter.ChangeSetFilter;
import liquibase.parser.filter.DbmsChangeSetFilter;
import liquibase.parser.visitor.ValidatingVisitor;
import liquibase.preconditions.Preconditions;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseChangeLog
implements Comparable<DatabaseChangeLog> {
    private Preconditions preconditions = new Preconditions();
    private String physicalFilePath;
    private String logicalFilePath;
    private List<ChangeSet> changeSets = new ArrayList<ChangeSet>();

    public DatabaseChangeLog(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public Preconditions getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(Preconditions precond) {
        this.preconditions = precond;
    }

    public String getPhysicalFilePath() {
        return this.physicalFilePath;
    }

    public void setPhysicalFilePath(String physicalFilePath) {
        this.physicalFilePath = physicalFilePath;
    }

    public String getLogicalFilePath() {
        if (this.logicalFilePath == null) {
            return this.physicalFilePath;
        }
        return this.logicalFilePath;
    }

    public void setLogicalFilePath(String logicalFilePath) {
        this.logicalFilePath = logicalFilePath;
    }

    public String getFilePath() {
        if (this.logicalFilePath == null) {
            return this.physicalFilePath;
        }
        return this.logicalFilePath;
    }

    public String toString() {
        return this.getFilePath();
    }

    @Override
    public int compareTo(DatabaseChangeLog o) {
        return this.getFilePath().compareTo(o.getFilePath());
    }

    public ChangeSet getChangeSet(String path, String author, String id) {
        for (ChangeSet changeSet : this.changeSets) {
            if (!changeSet.getFilePath().equals(path) || !changeSet.getAuthor().equals(author) || !changeSet.getId().equals(id)) continue;
            return changeSet;
        }
        return null;
    }

    public List<ChangeSet> getChangeSets() {
        return this.changeSets;
    }

    public void addChangeSet(ChangeSet changeSet) {
        this.changeSets.add(changeSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseChangeLog that = (DatabaseChangeLog)o;
        return this.getFilePath().equals(that.getFilePath());
    }

    public int hashCode() {
        return this.getFilePath().hashCode();
    }

    public void validate(Database database) throws LiquibaseException {
        ChangeLogIterator logIterator = new ChangeLogIterator(this, new ChangeSetFilter[]{new DbmsChangeSetFilter(database)});
        ValidatingVisitor validatingVisitor = new ValidatingVisitor(database.getRanChangeSetList());
        validatingVisitor.validate(database, this);
        logIterator.run(validatingVisitor, database);
        if (!validatingVisitor.validationPassed()) {
            throw new ValidationFailedException(validatingVisitor);
        }
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((DatabaseChangeLog)x0);
    }
}

