/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropPrimaryKeyChange;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddPrimaryKeyStatement;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddPrimaryKeyChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String columnNames;
    private String constraintName;

    public AddPrimaryKeyChange() {
        super("addPrimaryKey", "Add Primary Key");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.columnNames) == null) {
            throw new InvalidChangeDefinitionException("columnNames is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        AddPrimaryKeyStatement statement = new AddPrimaryKeyStatement(schemaName, this.getTableName(), this.getColumnNames(), this.getConstraintName());
        statement.setTablespace(this.getTablespace());
        if (database instanceof DB2Database) {
            return new SqlStatement[]{statement, new ReorganizeTableStatement(schemaName, this.getTableName())};
        }
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{statement};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                String[] split_columns;
                String[] arr$ = split_columns = AddPrimaryKeyChange.this.getColumnNames().split("[ ]*,[ ]*");
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String split_column = arr$[i$];
                    if (!column.getName().equals(split_column)) continue;
                    column.getConstraints().setPrimaryKey(true);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropPrimaryKeyChange inverse = new DropPrimaryKeyChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Primary key added to ").append(this.getTableName()).append(" (").append(this.getColumnNames()).append(")").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        node.setAttribute("tableName", this.getTableName());
        node.setAttribute("columnNames", this.getColumnNames());
        if (this.getConstraintName() != null) {
            node.setAttribute("constraintName", this.getConstraintName());
        }
        if (this.getTablespace() != null) {
            node.setAttribute("tablespace", this.getTablespace());
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> dbObjects = new HashSet<DatabaseObject>();
        Table table = new Table(this.getTableName());
        dbObjects.add(table);
        for (String columnName : this.columnNames.split(",")) {
            Column column = new Column();
            column.setTable(table);
            column.setName(columnName.trim());
            dbObjects.add(column);
        }
        return dbObjects;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

