/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.custom;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.change.AbstractChange;
import liquibase.change.custom.CustomChange;
import liquibase.change.custom.CustomSqlChange;
import liquibase.change.custom.CustomSqlRollback;
import liquibase.change.custom.CustomTaskChange;
import liquibase.change.custom.CustomTaskRollback;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.exception.CustomChangeException;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.ObjectUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomChangeWrapper
extends AbstractChange {
    private CustomChange customChange;
    private String className;
    private SortedSet<String> params = new TreeSet<String>();
    private Map<String, String> paramValues = new HashMap<String, String>();
    private ClassLoader classLoader;
    static /* synthetic */ Class class$liquibase$change$custom$CustomTaskChange;
    static /* synthetic */ Class class$liquibase$change$custom$CustomSqlChange;

    public CustomChangeWrapper() {
        super("customChange", "Custom Change");
    }

    public CustomChange getCustomChange() {
        return this.customChange;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setClass(String className) throws CustomChangeException {
        this.className = className;
        try {
            try {
                this.customChange = (CustomChange)Class.forName(className, true, this.classLoader).newInstance();
            }
            catch (ClassCastException e) {
                this.customChange = (CustomChange)Class.forName(className).newInstance();
            }
        }
        catch (Exception e) {
            throw new CustomChangeException(e);
        }
    }

    public void setParam(String name, String value) {
        this.params.add(name);
        this.paramValues.put(name, value);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        this.customChange.validate(database);
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        SqlStatement[] statements;
        block7: {
            statements = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlChange) {
                    statements = ((CustomSqlChange)this.customChange).generateStatements(database);
                    break block7;
                }
                if (this.customChange instanceof CustomTaskChange) {
                    ((CustomTaskChange)this.customChange).execute(database);
                    break block7;
                }
                StringBuffer stringBuffer = new StringBuffer().append(this.customChange.getClass().getName()).append(" does not implement ");
                Class<?> clazz = class$liquibase$change$custom$CustomSqlChange;
                if (clazz == null) {
                    clazz = class$liquibase$change$custom$CustomSqlChange = new CustomSqlChange[0].getClass().getComponentType();
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append(" or ");
                Class<?> clazz2 = class$liquibase$change$custom$CustomTaskChange;
                if (clazz2 == null) {
                    clazz2 = class$liquibase$change$custom$CustomTaskChange = new CustomTaskChange[0].getClass().getComponentType();
                }
                throw new UnsupportedChangeException(stringBuffer2.append(clazz2.getName()).toString());
            }
            catch (CustomChangeException e) {
                throw new UnsupportedChangeException(e);
            }
        }
        if (statements == null) {
            statements = new SqlStatement[]{};
        }
        return statements;
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        SqlStatement[] statements;
        block5: {
            statements = null;
            try {
                this.configureCustomChange();
                if (this.customChange instanceof CustomSqlRollback) {
                    statements = ((CustomSqlRollback)((Object)this.customChange)).generateRollbackStatements(database);
                    break block5;
                }
                if (this.customChange instanceof CustomTaskRollback) {
                    ((CustomTaskRollback)((Object)this.customChange)).rollback(database);
                    break block5;
                }
                throw new UnsupportedChangeException(new StringBuffer().append("Unknown rollback type: ").append(this.customChange.getClass().getName()).toString());
            }
            catch (CustomChangeException e) {
                throw new UnsupportedChangeException(e);
            }
        }
        if (statements == null) {
            statements = new SqlStatement[]{};
        }
        return statements;
    }

    @Override
    public boolean canRollBack() {
        return this.customChange instanceof CustomSqlRollback || this.customChange instanceof CustomTaskRollback;
    }

    private void configureCustomChange() throws CustomChangeException {
        try {
            for (String param : this.params) {
                ObjectUtil.setProperty(this.customChange, param, this.paramValues.get(param));
            }
            this.customChange.setFileOpener(this.getFileOpener());
            this.customChange.setUp();
        }
        catch (Exception e) {
            throw new CustomChangeException(e);
        }
    }

    @Override
    public String getConfirmationMessage() {
        return this.customChange.getConfirmationMessage();
    }

    @Override
    public Element createNode(Document currentChangeLogDOM) {
        Element customElement = currentChangeLogDOM.createElement("custom");
        customElement.setAttribute("class", this.className);
        for (String param : this.params) {
            Element paramElement = currentChangeLogDOM.createElement("param");
            paramElement.setAttribute("name", param);
            paramElement.setAttribute("value", this.paramValues.get(param));
            customElement.appendChild(paramElement);
        }
        return customElement;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

