/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.text.ParseException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DataType;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.OracleDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "oracle";
    private static final DataType BOOLEAN_TYPE = new DataType("NUMBER(1)", false);
    private static final DataType CURRENCY_TYPE = new DataType("NUMBER(15, 2)", false);
    private static final DataType UUID_TYPE = new DataType("RAW(16)", false);
    private static final DataType CLOB_TYPE = new DataType("CLOB", false);
    private static final DataType BLOB_TYPE = new DataType("BLOB", false);
    private static final DataType DATETIME_TYPE = new DataType("TIMESTAMP", true);
    private static final DataType DATE_TYPE = new DataType("DATE", false);
    private static final DataType BIGINT_TYPE = new DataType("NUMBER(19,0)", false);

    @Override
    public void setConnection(Connection conn) {
        try {
            Method method = conn.getClass().getMethod("setRemarksReporting", Boolean.TYPE);
            method.setAccessible(true);
            method.invoke((Object)conn, true);
        }
        catch (Exception e) {
            log.info(new StringBuffer().append("Could not set remarks reporting on OracleDatabase: ").append(e.getMessage()).toString());
        }
        super.setConnection(conn);
    }

    @Override
    public String getProductName() {
        return "Oracle";
    }

    @Override
    public String getTypeName() {
        return PRODUCT_NAME;
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public DataType getBooleanType() {
        return BOOLEAN_TYPE;
    }

    @Override
    public DataType getCurrencyType() {
        return CURRENCY_TYPE;
    }

    @Override
    public DataType getUUIDType() {
        return UUID_TYPE;
    }

    @Override
    public DataType getClobType() {
        return CLOB_TYPE;
    }

    @Override
    public DataType getBlobType() {
        return BLOB_TYPE;
    }

    @Override
    public DataType getDateTimeType() {
        return DATETIME_TYPE;
    }

    @Override
    public DataType getDateType() {
        return DATE_TYPE;
    }

    @Override
    public DataType getTimeType() {
        return DATE_TYPE;
    }

    @Override
    public DataType getBigIntType() {
        return BIGINT_TYPE;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:oracle")) {
            return "oracle.jdbc.OracleDriver";
        }
        return null;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "SYSDATE";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public String getDateLiteral(String isoDate) {
        String normalLiteral = super.getDateLiteral(isoDate);
        if (this.isDateOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD')");
            return val.toString();
        }
        if (this.isTimeOnly(isoDate)) {
            StringBuffer val = new StringBuffer();
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'HH24:MI:SS')");
            return val.toString();
        }
        if (this.isDateTime(isoDate)) {
            normalLiteral = new StringBuffer().append(normalLiteral.substring(0, normalLiteral.lastIndexOf(46))).append("'").toString();
            StringBuffer val = new StringBuffer(26);
            val.append("to_date(");
            val.append(normalLiteral);
            val.append(", 'YYYY-MM-DD HH24:MI:SS')");
            return val.toString();
        }
        return new StringBuffer().append("UNSUPPORTED:").append(isoDate).toString();
    }

    @Override
    public SqlStatement getSelectChangeLogLockSQL() throws JDBCException {
        return new RawSqlStatement(new StringBuffer().append(super.getSelectChangeLogLockSQL().getSqlStatement(this)).append(" for update").toString().toUpperCase());
    }

    @Override
    public SqlStatement createFindSequencesSQL(String schema) throws JDBCException {
        return new RawSqlStatement(new StringBuffer().append("SELECT SEQUENCE_NAME FROM ALL_SEQUENCES WHERE SEQUENCE_OWNER = '").append(this.convertRequestedSchemaToSchema(schema)).append("'").toString());
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        if (super.isSystemTable(catalogName, schemaName, tableName)) {
            return true;
        }
        if (tableName.startsWith("BIN$")) {
            return true;
        }
        if (tableName.startsWith("AQ$")) {
            return true;
        }
        return tableName.startsWith("DR$");
    }

    @Override
    public boolean shouldQuoteValue(String value) {
        return super.shouldQuoteValue(value) && !value.startsWith("to_date(") && !value.equalsIgnoreCase(this.getCurrentDateTimeFunction());
    }

    @Override
    public boolean supportsTablespaces() {
        return true;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String name) throws JDBCException {
        return new RawSqlStatement(new StringBuffer().append("SELECT TEXT FROM ALL_VIEWS WHERE upper(VIEW_NAME)='").append(name.toUpperCase()).append("' AND OWNER='").append(this.convertRequestedSchemaToSchema(schemaName)).append("'").toString());
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object defaultValue, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (defaultValue != null && defaultValue instanceof String) {
            if (dataType == 91 || dataType == 92 || dataType == 93) {
                defaultValue = ((String)defaultValue).indexOf("YYYY-MM-DD HH") > 0 ? ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD HH24:MI:SS'\\)$", "") : (((String)defaultValue).indexOf("YYYY-MM-DD") > 0 ? ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'YYYY-MM-DD'\\)$", "") : ((String)defaultValue).replaceFirst("^to_date\\('", "").replaceFirst("', 'HH24:MI:SS'\\)$", ""));
            }
            defaultValue = ((String)defaultValue).replaceFirst("'\\s*$", "'");
        }
        return super.convertDatabaseValueToJavaObject(defaultValue, dataType, columnSize, decimalDigits);
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new OracleDatabaseSnapshot(this, statusListeners, schema);
    }

    @Override
    public boolean supportsRestrictForeignKeys() {
        return false;
    }
}

