/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.RanChangeSet;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.SetupException;
import liquibase.parser.visitor.ChangeSetVisitor;
import liquibase.preconditions.ErrorPrecondition;
import liquibase.preconditions.FailedPrecondition;
import liquibase.preconditions.Preconditions;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingVisitor
implements ChangeSetVisitor {
    private List<ChangeSet> invalidMD5Sums = new ArrayList<ChangeSet>();
    private List<FailedPrecondition> failedPreconditions = new ArrayList<FailedPrecondition>();
    private List<ErrorPrecondition> errorPreconditions = new ArrayList<ErrorPrecondition>();
    private Set<ChangeSet> duplicateChangeSets = new HashSet<ChangeSet>();
    private List<SetupException> setupExceptions = new ArrayList<SetupException>();
    private List<InvalidChangeDefinitionException> changeValidationExceptions = new ArrayList<InvalidChangeDefinitionException>();
    private Set<String> seenChangeSets = new HashSet<String>();
    private List<RanChangeSet> ranChangeSets;

    public ValidatingVisitor(List<RanChangeSet> ranChangeSets) {
        this.ranChangeSets = ranChangeSets;
    }

    public void validate(Database database, DatabaseChangeLog changeLog) {
        try {
            Preconditions precondition = changeLog.getPreconditions();
            if (precondition == null) {
                return;
            }
            precondition.check(database, changeLog);
        }
        catch (PreconditionFailedException e) {
            this.failedPreconditions.addAll(e.getFailedPreconditions());
        }
        catch (PreconditionErrorException e) {
            this.errorPreconditions.addAll(e.getErrorPreconditions());
        }
    }

    @Override
    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    @Override
    public void visit(ChangeSet changeSet, Database database) {
        for (Change change : changeSet.getChanges()) {
            try {
                change.setUp();
            }
            catch (SetupException se) {
                this.setupExceptions.add(se);
            }
            try {
                change.validate(database);
            }
            catch (InvalidChangeDefinitionException e) {
                this.changeValidationExceptions.add(e);
            }
        }
        for (RanChangeSet ranChangeSet : this.ranChangeSets) {
            if (!ranChangeSet.getId().equals(changeSet.getId()) || !ranChangeSet.getAuthor().equals(changeSet.getAuthor()) || !ranChangeSet.getChangeLog().equals(changeSet.getFilePath()) || changeSet.isCheckSumValid(ranChangeSet.getMd5sum()) || changeSet.shouldRunOnChange()) continue;
            this.invalidMD5Sums.add(changeSet);
        }
        String changeSetString = changeSet.toString(false);
        if (this.seenChangeSets.contains(changeSetString)) {
            this.duplicateChangeSets.add(changeSet);
        } else {
            this.seenChangeSets.add(changeSetString);
        }
    }

    public List<ChangeSet> getInvalidMD5Sums() {
        return this.invalidMD5Sums;
    }

    public List<FailedPrecondition> getFailedPreconditions() {
        return this.failedPreconditions;
    }

    public List<ErrorPrecondition> getErrorPreconditions() {
        return this.errorPreconditions;
    }

    public Set<ChangeSet> getDuplicateChangeSets() {
        return this.duplicateChangeSets;
    }

    public List<SetupException> getSetupExceptions() {
        return this.setupExceptions;
    }

    public List<InvalidChangeDefinitionException> getChangeValidationExceptions() {
        return this.changeValidationExceptions;
    }

    public boolean validationPassed() {
        return this.invalidMD5Sums.size() == 0 && this.failedPreconditions.size() == 0 && this.errorPreconditions.size() == 0 && this.duplicateChangeSets.size() == 0 && this.changeValidationExceptions.size() == 0 && this.setupExceptions.size() == 0;
    }
}

