/*
 * Decompiled with CFR 0.152.
 */
package liquibase.retro.net.sf.retrotranslator.runtime.format;

import liquibase.retro.net.sf.retrotranslator.runtime.format.FormatContext;
import liquibase.retro.net.sf.retrotranslator.runtime.format.NumericConversion;

class HexadecimalExponentialConversion
extends NumericConversion {
    HexadecimalExponentialConversion() {
    }

    public void format(FormatContext context) {
        context.checkFlags();
        context.assertNoFlag('(');
        context.assertNoFlag(',');
        Object argument = context.getArgument();
        if (argument instanceof Double) {
            HexadecimalExponentialConversion.printf(context, (Double)argument);
        } else if (argument instanceof Float) {
            HexadecimalExponentialConversion.printf(context, ((Float)argument).floatValue());
        } else if (argument == null) {
            context.writeRestricted(String.valueOf(argument));
        } else {
            throw context.getConversionException();
        }
    }

    private static void printf(FormatContext context, double argument) {
        if (!HexadecimalExponentialConversion.printSpecialNumber(context, argument)) {
            context.writePadded(HexadecimalExponentialConversion.toHex(context, argument));
        }
    }

    private static String toHex(FormatContext context, double argument) {
        StringBuffer builder = new StringBuffer();
        long bits = Double.doubleToLongBits(argument);
        if (bits < 0L) {
            builder.append('-');
        } else if (context.isFlag('+')) {
            builder.append('+');
        }
        int exponent = HexadecimalExponentialConversion.getExponent(bits);
        int precision = context.getPrecision();
        if (argument != 0.0 && precision >= 0 && precision <= 12) {
            if (exponent == 0) {
                bits = Double.doubleToLongBits(argument * 4.503599627370496E15);
                exponent = HexadecimalExponentialConversion.getExponent(bits) - 52;
            }
            double value = Double.longBitsToDouble(HexadecimalExponentialConversion.getSignificand(bits));
            double factor = 1L << 52 - 4 * Math.max(precision, 1);
            bits = Double.doubleToLongBits(value / factor * factor);
            exponent += HexadecimalExponentialConversion.getExponent(bits) - 1;
        }
        builder.append(exponent == 0 ? "0x0." : "0x1.");
        HexadecimalExponentialConversion.appendSignificand(builder, bits, precision);
        return builder.append('p').append(argument == 0.0 ? 0 : (exponent == 0 ? -1022 : exponent - 1023)).toString();
    }

    private static int getExponent(long bits) {
        return (int)(bits << 1 >>> 53);
    }

    private static long getSignificand(long bits) {
        return bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
    }

    private static void appendSignificand(StringBuffer builder, long bits, int precision) {
        int endIndex;
        String s = Long.toHexString(HexadecimalExponentialConversion.getSignificand(bits));
        for (endIndex = s.length(); endIndex > 2 && s.charAt(endIndex - 1) == '0'; --endIndex) {
        }
        builder.append(s.substring(1, endIndex));
        for (int i = endIndex; i <= precision; ++i) {
            builder.append('0');
        }
    }
}

