/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DataType;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.UnsupportedDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsupportedDatabase
extends AbstractDatabase {
    private String dateTimeType;
    private static final DataType BOOLEAN_TYPE = new DataType("INT", false);
    private static final DataType CURRENCY_TYPE = new DataType("DECIMAL", true);
    private static final DataType UUID_TYPE = new DataType("CHAR(36)", false);
    private static final DataType CLOB_TYPE = new DataType("CLOB", false);
    private static final DataType BLOB_TYPE = new DataType("BLOB", false);

    @Override
    public void setConnection(Connection conn) {
        super.setConnection(conn);
        this.dateTimeType = this.findDateTypeType();
        if (this.currentDateTimeFunction == null) {
            this.currentDateTimeFunction = this.findCurrentDateTimeFunction();
        }
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        return null;
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return null;
    }

    @Override
    public DataType getBooleanType() {
        return BOOLEAN_TYPE;
    }

    @Override
    public String getFalseBooleanValue() {
        return "0";
    }

    @Override
    public String getTrueBooleanValue() {
        return "1";
    }

    @Override
    public DataType getCurrencyType() {
        return CURRENCY_TYPE;
    }

    @Override
    public DataType getUUIDType() {
        return UUID_TYPE;
    }

    @Override
    public DataType getClobType() {
        return CLOB_TYPE;
    }

    @Override
    public DataType getBlobType() {
        return BLOB_TYPE;
    }

    @Override
    public DataType getDateTimeType() {
        return new DataType(this.dateTimeType, false);
    }

    private String findDateTypeType() {
        ResultSet typeInfo = null;
        try {
            typeInfo = this.getConnection().getMetaData().getTypeInfo();
            while (typeInfo.next()) {
                if (typeInfo.getInt("DATA_TYPE") != 93) continue;
                String string = typeInfo.getString("TYPE_NAME");
                return string;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (typeInfo != null) {
                try {
                    typeInfo.close();
                }
                catch (SQLException e) {}
            }
        }
        return "DATETIME";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return false;
    }

    @Override
    public String getDefaultDriver(String url) {
        return null;
    }

    @Override
    public String getProductName() {
        return new StringBuffer().append("Unsupported Database (").append(this.getDatabaseProductName()).append(")").toString();
    }

    @Override
    public String getTypeName() {
        return this.getDatabaseProductName().toLowerCase().replaceAll("\\W", "");
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return this.currentDateTimeFunction;
    }

    private String findCurrentDateTimeFunction() {
        try {
            String[] timeDateFunctions;
            String nowFunction = null;
            String dateFunction = null;
            String dateTimeFunction = null;
            String timeStampFunction = null;
            for (String functionName : timeDateFunctions = this.getConnection().getMetaData().getTimeDateFunctions().split(",")) {
                String function = functionName.trim().toUpperCase();
                if (function.endsWith("TIMESTAMP")) {
                    timeStampFunction = functionName.trim();
                }
                if (function.endsWith("DATETIME")) {
                    dateTimeFunction = functionName.trim();
                }
                if (function.endsWith("DATE")) {
                    dateFunction = functionName.trim();
                }
                if (!"NOW".equals(function)) continue;
                nowFunction = functionName.trim();
            }
            if (nowFunction != null) {
                return new StringBuffer().append("{fn ").append(nowFunction).append("()").append("}").toString();
            }
            if (timeStampFunction != null) {
                return new StringBuffer().append("{fn ").append(timeStampFunction).append("()").append("}").toString();
            }
            if (dateTimeFunction != null) {
                return new StringBuffer().append("{fn ").append(dateTimeFunction).append("()").append("}").toString();
            }
            if (dateFunction != null) {
                return new StringBuffer().append("{fn ").append(dateFunction).append("()").append("}").toString();
            }
            return "CURRENT_TIMESTAMP";
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected boolean canCreateChangeLogTable() throws JDBCException {
        try {
            int maxIndexLength = this.getConnection().getMetaData().getMaxIndexLength();
            return maxIndexLength == 0 || maxIndexLength >= 555 && super.canCreateChangeLogTable();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new UnsupportedDatabaseSnapshot(this, statusListeners, schema);
    }
}

