/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class LiquibaseStatusServlet
extends HttpServlet {
    private static List<LogRecord> liquibaseRunLog = new ArrayList<LogRecord>();

    public static synchronized void logMessage(LogRecord message) {
        liquibaseRunLog.add(message);
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletResponse.setContentType("text/html");
        String logLevelToDisplay = httpServletRequest.getParameter("logLevel");
        Level currentLevel = Level.INFO;
        if (logLevelToDisplay != null) {
            currentLevel = Level.parse(logLevelToDisplay);
        }
        PrintWriter writer = httpServletResponse.getWriter();
        writer.println("<html>");
        writer.println("<head><title>LiquiBase Status</title></head>");
        writer.println("<body>");
        if (liquibaseRunLog.size() == 0) {
            writer.println("<b>LiquiBase did not run</b>");
        } else {
            writer.println("<b>View level: " + this.getLevelLink(Level.SEVERE, currentLevel, httpServletRequest) + " " + this.getLevelLink(Level.WARNING, currentLevel, httpServletRequest) + " " + this.getLevelLink(Level.INFO, currentLevel, httpServletRequest) + " " + this.getLevelLink(Level.CONFIG, currentLevel, httpServletRequest) + " " + this.getLevelLink(Level.FINE, currentLevel, httpServletRequest) + " " + this.getLevelLink(Level.FINER, currentLevel, httpServletRequest) + " " + this.getLevelLink(Level.FINEST, currentLevel, httpServletRequest) + "</b>");
            writer.println("<hr>");
            writer.println("<b>LiquiBase started at " + DateFormat.getDateTimeInstance().format(new Date(liquibaseRunLog.get(0).getMillis())));
            writer.println("<hr>");
            writer.println("<pre>");
            Iterator<LogRecord> i$ = liquibaseRunLog.iterator();
            while (i$.hasNext()) {
                LogRecord record = i$.next();
                if (record.getLevel().intValue() < currentLevel.intValue()) continue;
                writer.println(record.getLevel() + ": " + record.getMessage());
                if (record.getThrown() == null) continue;
                record.getThrown().printStackTrace(writer);
            }
            writer.println("");
            writer.println("");
            writer.println("</pre>");
            writer.println("<hr>");
            writer.println("<b>LiquiBase finished at " + DateFormat.getDateTimeInstance().format(new Date(liquibaseRunLog.get(liquibaseRunLog.size() - 1).getMillis())));
        }
        writer.println("</body>");
        writer.println("</html>");
    }

    private String getLevelLink(Level level, Level currentLevel, HttpServletRequest request) {
        if (currentLevel.equals(level)) {
            return level.getName();
        }
        return "<a href=" + request.getRequestURI() + "?logLevel=" + level.getName() + ">" + level.getName() + "</a>";
    }
}

