/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.AbstractDatabase;
import liquibase.database.DataType;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.MaxDBDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxDBDatabase
extends AbstractDatabase {
    public static final String PRODUCT_NAME = "SAP DB";
    protected Set<String> systemTablesAndViews = new HashSet<String>();
    private static final DataType BOOLEAN_TYPE = new DataType("BOOLEAN", false);
    private static final DataType CURRENCY_TYPE = new DataType("NUMERIC(15, 2)", false);
    private static final DataType UUID_TYPE = new DataType("CHAR(36)", false);
    private static final DataType CLOB_TYPE = new DataType("LONG VARCHAR", false);
    private static final DataType BLOB_TYPE = new DataType("LONG BYTE", false);
    private static final DataType DATETIME_TYPE = new DataType("TIMESTAMP", false);
    private static final DataType DATE_TYPE = new DataType("DATE", false);
    private static final DataType TIME_TYPE = new DataType("TIME", false);

    public MaxDBDatabase() {
        this.systemTablesAndViews.add("---");
        this.systemTablesAndViews.add("ACTIVECONFIGURATION");
        this.systemTablesAndViews.add("BACKUPTHREADS");
        this.systemTablesAndViews.add("CACHESTATISTICS");
        this.systemTablesAndViews.add("CATALOGCACHESTATISTICS");
        this.systemTablesAndViews.add("COMMANDCACHESTATISTICS");
        this.systemTablesAndViews.add("COMMANDCACHESTATISTICSRESET");
        this.systemTablesAndViews.add("COMMANDSTATISTICS");
        this.systemTablesAndViews.add("COMMANDSTATISTICSRESET");
        this.systemTablesAndViews.add("CONSISTENTVIEWS");
        this.systemTablesAndViews.add("DATACACHE");
        this.systemTablesAndViews.add("DATASTATISTICS");
        this.systemTablesAndViews.add("DATASTATISTICSRESET");
        this.systemTablesAndViews.add("DATAVOLUMES");
        this.systemTablesAndViews.add("DATASTATISTICSRESET");
        this.systemTablesAndViews.add("FILEDIRECTORIES");
        this.systemTablesAndViews.add("FILES");
        this.systemTablesAndViews.add("HOTSTANDBYCOMPONENT");
        this.systemTablesAndViews.add("HOTSTANDBYGROUP");
        this.systemTablesAndViews.add("INSTANCE");
        this.systemTablesAndViews.add("IOBUFFERCACHES");
        this.systemTablesAndViews.add("IOTHREADSTATISTICS");
        this.systemTablesAndViews.add("IOTHREADSTATISTICSRESET");
        this.systemTablesAndViews.add("INDEXSIZE");
        this.systemTablesAndViews.add("INDEXSTORAGEDETAILS");
        this.systemTablesAndViews.add("LOGINFORMATION");
        this.systemTablesAndViews.add("LOGQUEUESTATISTICS");
        this.systemTablesAndViews.add("LOGQUEUESTATISTICSRESET");
        this.systemTablesAndViews.add("LOGSTATISTICS");
        this.systemTablesAndViews.add("LOGSTATISTICSRESET");
        this.systemTablesAndViews.add("LOGVOLUMES");
        this.systemTablesAndViews.add("MACHINECONFIGURATION");
        this.systemTablesAndViews.add("MACHINEUTILIZATION");
        this.systemTablesAndViews.add("MEMORYALLOCATORSTATISTICS");
        this.systemTablesAndViews.add("OPTIMIZERINFORMATION");
        this.systemTablesAndViews.add("READERWRITERLOCKINFORMATION");
        this.systemTablesAndViews.add("READERWRITERLOCKSTATISTICS");
        this.systemTablesAndViews.add("READERWRITERLOCKSTATISTICSRESET");
        this.systemTablesAndViews.add("READERWRITERLOCKWAITINGTASKS");
        this.systemTablesAndViews.add("REGIONINFORMATION");
        this.systemTablesAndViews.add("REGIONSTATISTICS");
        this.systemTablesAndViews.add("REGIONSTATISTICSRESET");
        this.systemTablesAndViews.add("RESTARTINFORMATION");
        this.systemTablesAndViews.add("SCHEMASIZE");
        this.systemTablesAndViews.add("SERVERTASKS");
        this.systemTablesAndViews.add("SESSIONS");
        this.systemTablesAndViews.add("SNAPSHOTS");
        this.systemTablesAndViews.add("SPINLOCKPOOLSTATISTICS");
        this.systemTablesAndViews.add("SPINLOCKPOOLSTATISTICSRESET");
        this.systemTablesAndViews.add("SPINLOCKSTATISTICS");
        this.systemTablesAndViews.add("SPINLOCKSTATISTICSRESET");
        this.systemTablesAndViews.add("TABLESIZE");
        this.systemTablesAndViews.add("TABLESTORAGEDETAILS");
        this.systemTablesAndViews.add("TASKGROUPSTATISTICS");
        this.systemTablesAndViews.add("TASKGROUPSTATISTICSRESET");
        this.systemTablesAndViews.add("TASKLOADBALANCINGINFORMATION");
        this.systemTablesAndViews.add("TASKLOADBALANCINGTASKGROUPSTATES");
        this.systemTablesAndViews.add("TASKLOADBALANCINGTASKMOVES");
        this.systemTablesAndViews.add("TRANSACTIONHISTORY");
        this.systemTablesAndViews.add("TRANSACTIONS");
        this.systemTablesAndViews.add("UNLOADEDSTATEMENTS");
        this.systemTablesAndViews.add("VERSION");
    }

    @Override
    public Set<String> getSystemTablesAndViews() {
        return this.systemTablesAndViews;
    }

    @Override
    public String getProductName() {
        return "MaxDB";
    }

    @Override
    public String getTypeName() {
        return "maxdb";
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public DataType getBooleanType() {
        return BOOLEAN_TYPE;
    }

    @Override
    public DataType getCurrencyType() {
        return CURRENCY_TYPE;
    }

    @Override
    public DataType getUUIDType() {
        return UUID_TYPE;
    }

    @Override
    public DataType getClobType() {
        return CLOB_TYPE;
    }

    @Override
    public DataType getBlobType() {
        return BLOB_TYPE;
    }

    @Override
    public DataType getDateTimeType() {
        return DATETIME_TYPE;
    }

    @Override
    public DataType getDateType() {
        return DATE_TYPE;
    }

    @Override
    public DataType getTimeType() {
        return TIME_TYPE;
    }

    @Override
    public boolean isCorrectDatabaseImplementation(Connection conn) throws JDBCException {
        return PRODUCT_NAME.equalsIgnoreCase(this.getDatabaseProductName(conn));
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sapdb")) {
            return "com.sap.dbtech.jdbc.DriverSapDB";
        }
        return null;
    }

    @Override
    public String getCurrentDateTimeFunction() {
        return "TIMESTAMP";
    }

    @Override
    public String getTrueBooleanValue() {
        return "TRUE";
    }

    @Override
    public String getFalseBooleanValue() {
        return "FALSE";
    }

    @Override
    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return super.getDefaultDatabaseSchemaName().toUpperCase();
    }

    @Override
    public SqlStatement createFindSequencesSQL(String schema) throws JDBCException {
        return new RawSqlStatement(new StringBuffer().append("SELECT SEQUENCE_NAME FROM DOMAIN.SEQUENCES WHERE OWNER = '").append(this.convertRequestedSchemaToSchema(schema)).append("'").toString());
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        if (super.isSystemTable(catalogName, schemaName, tableName)) {
            return true;
        }
        if ("DOMAIN".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSINFO".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSLOADER".equalsIgnoreCase(schemaName)) {
            return true;
        }
        return "SYSDBA".equalsIgnoreCase(schemaName);
    }

    @Override
    public boolean isSystemView(String catalogName, String schemaName, String tableName) {
        if (super.isSystemView(catalogName, schemaName, tableName)) {
            return true;
        }
        if ("DOMAIN".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSINFO".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if ("SYSLOADER".equalsIgnoreCase(schemaName)) {
            return true;
        }
        return "SYSDBA".equalsIgnoreCase(schemaName);
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public SqlStatement getViewDefinitionSql(String schemaName, String name) throws JDBCException {
        return new RawSqlStatement(new StringBuffer().append("SELECT DEFINITION FROM DOMAIN.VIEWDEFS WHERE upper(VIEWNAME)='").append(name.toUpperCase()).append("' AND OWNER='").append(this.convertRequestedSchemaToSchema(schemaName)).append("'").toString());
    }

    @Override
    public boolean supportsAutoIncrement() {
        return false;
    }

    @Override
    public String convertJavaObjectToString(Object value) {
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return this.getTrueBooleanValue();
            }
            return this.getFalseBooleanValue();
        }
        return super.convertJavaObjectToString(value);
    }

    @Override
    public DatabaseSnapshot createDatabaseSnapshot(String schema, Set<DiffStatusListener> statusListeners) throws JDBCException {
        return new MaxDBDatabaseSnapshot(this, statusListeners, schema);
    }
}

