/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.exception.JDBCException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;
import liquibase.util.StringUtils;

public class ForeignKeyExistsPrecondition
implements Precondition {
    private String schemaName;
    private String foreignKeyName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getForeignKeyName() {
        return this.foreignKeyName;
    }

    public void setForeignKeyName(String foreignKeyName) {
        this.foreignKeyName = foreignKeyName;
    }

    public void check(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        DatabaseSnapshot databaseSnapshot;
        try {
            databaseSnapshot = database.createDatabaseSnapshot(this.getSchemaName(), null);
        }
        catch (JDBCException e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
        if (databaseSnapshot.getForeignKey(this.getForeignKeyName()) == null) {
            throw new PreconditionFailedException("Foreign Key " + database.escapeStringForDatabase(this.getForeignKeyName()) + " does not exist", changeLog, this);
        }
    }

    public String getTagName() {
        return "foreignKeyConstraintExists";
    }
}

