/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.H2Database;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnType;
    private Object defaultValue;
    private Set<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();

    public AddColumnStatement(String schemaName, String tableName, String columnName, String columnType, Object defaultValue, ColumnConstraint[] constraints) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnType = columnType;
        this.defaultValue = defaultValue;
        if (constraints != null) {
            this.constraints.addAll(Arrays.asList(constraints));
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public Set<ColumnConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (this.isPrimaryKey() && (database instanceof CacheDatabase || database instanceof H2Database || database instanceof DB2Database || database instanceof DerbyDatabase || database instanceof SQLiteDatabase)) {
            throw new StatementNotSupportedOnDatabaseException("Adding primary key columns is not supported", this, database);
        }
        String alterTable = new StringBuffer().append("ALTER TABLE ").append(database.escapeTableName(this.getSchemaName(), this.getTableName())).append(" ADD ").append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName())).append(" ").append(database.getColumnType(this.getColumnType(), this.isAutoIncrement())).toString();
        if (this.defaultClauseBeforeNotNull(database)) {
            alterTable = new StringBuffer().append(alterTable).append(this.getDefaultClause(database)).toString();
        }
        if (this.primaryKeyBeforeNotNull(database) && this.isPrimaryKey()) {
            alterTable = new StringBuffer().append(alterTable).append(" PRIMARY KEY").toString();
        }
        if (this.isAutoIncrement()) {
            alterTable = new StringBuffer().append(alterTable).append(" ").append(database.getAutoIncrementClause()).toString();
        }
        if (!this.isNullable()) {
            alterTable = new StringBuffer().append(alterTable).append(" NOT NULL").toString();
        } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
            alterTable = new StringBuffer().append(alterTable).append(" NULL").toString();
        }
        if (!this.primaryKeyBeforeNotNull(database) && this.isPrimaryKey()) {
            alterTable = new StringBuffer().append(alterTable).append(" PRIMARY KEY").toString();
        }
        if (!this.defaultClauseBeforeNotNull(database)) {
            alterTable = new StringBuffer().append(alterTable).append(this.getDefaultClause(database)).toString();
        }
        return alterTable;
    }

    private boolean primaryKeyBeforeNotNull(Database database) {
        return !(database instanceof HsqlDatabase);
    }

    public boolean isAutoIncrement() {
        for (ColumnConstraint constraint : this.getConstraints()) {
            if (!(constraint instanceof AutoIncrementConstraint)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryKey() {
        for (ColumnConstraint constraint : this.getConstraints()) {
            if (!(constraint instanceof PrimaryKeyConstraint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    private boolean defaultClauseBeforeNotNull(Database database) {
        return database instanceof OracleDatabase || database instanceof HsqlDatabase || database instanceof DerbyDatabase || database instanceof DB2Database || database instanceof FirebirdDatabase;
    }

    private String getDefaultClause(Database database) {
        String clause = "";
        if (this.getDefaultValue() != null) {
            if (database instanceof MSSQLDatabase) {
                clause = new StringBuffer().append(clause).append(" CONSTRAINT ").append(((MSSQLDatabase)database).generateDefaultConstraintName(this.tableName, this.getColumnName())).toString();
            }
            clause = new StringBuffer().append(clause).append(" DEFAULT ").append(database.convertJavaObjectToString(this.getDefaultValue())).toString();
        }
        return clause;
    }

    public boolean isNullable() {
        if (this.isPrimaryKey()) {
            return false;
        }
        for (ColumnConstraint constraint : this.getConstraints()) {
            if (!(constraint instanceof NotNullConstraint)) continue;
            return false;
        }
        return true;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

