/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class CommentStatement
implements SqlStatement {
    private final String text;
    private final int MAX_LENGTH = 80;

    public CommentStatement(String text) {
        this.text = text;
    }

    public int hashCode() {
        return this.text.hashCode();
    }

    public String toString() {
        if (this.text != null && this.text.length() >= 80) {
            return this.text.substring(0, 77) + "...";
        }
        return this.getText();
    }

    public String getText() {
        return this.text;
    }

    public String getEndDelimiter(Database database) {
        return "\n";
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        return database.getLineComment() + ' ' + this.getText();
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

