/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DropColumnChange;
import liquibase.change.DropDefaultValueChange;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddColumnStatement;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddColumnChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public AddColumnChange() {
        super("addColumn", "Add Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public ColumnConfig getLastColumn() {
        return this.columns.size() > 0 ? this.columns.get(this.columns.size() - 1) : null;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig column : this.getColumns()) {
            if (StringUtils.trimToNull(column.getName()) == null) {
                throw new InvalidChangeDefinitionException("column name is required", this);
            }
            if (StringUtils.trimToNull(column.getType()) != null) continue;
            throw new InvalidChangeDefinitionException("column type is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> sql = new ArrayList<SqlStatement>();
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        for (ColumnConfig aColumn : this.columns) {
            HashSet<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();
            if (aColumn.getConstraints() != null) {
                if (aColumn.getConstraints().isNullable() != null && !aColumn.getConstraints().isNullable().booleanValue()) {
                    constraints.add(new NotNullConstraint());
                }
                if (aColumn.getConstraints().isPrimaryKey() != null && aColumn.getConstraints().isPrimaryKey().booleanValue()) {
                    constraints.add(new PrimaryKeyConstraint(aColumn.getConstraints().getPrimaryKeyName()));
                }
            }
            if (aColumn.isAutoIncrement() != null && aColumn.isAutoIncrement().booleanValue()) {
                constraints.add(new AutoIncrementConstraint(aColumn.getName()));
            }
            AddColumnStatement addColumnStatement = new AddColumnStatement(schemaName, this.getTableName(), aColumn.getName(), aColumn.getType(), aColumn.getDefaultValueObject(), constraints.toArray(new ColumnConstraint[constraints.size()]));
            sql.add(addColumnStatement);
            if (aColumn.getValueObject() == null) continue;
            UpdateStatement updateStatement = new UpdateStatement(schemaName, this.getTableName());
            updateStatement.addNewColumnValue(aColumn.getName(), aColumn.getValueObject());
            sql.add(updateStatement);
        }
        if (database instanceof DB2Database) {
            sql.add(new ReorganizeTableStatement(schemaName, this.getTableName()));
        }
        return sql.toArray(new SqlStatement[sql.size()]);
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                ColumnConfig[] columnsToAdd = new ColumnConfig[AddColumnChange.this.columns.size()];
                for (int i = 0; i < AddColumnChange.this.columns.size(); ++i) {
                    columnsToAdd[i] = new ColumnConfig((ColumnConfig)AddColumnChange.this.columns.get(i));
                }
                return columnsToAdd;
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        ArrayList<AbstractChange> inverses = new ArrayList<AbstractChange>();
        for (ColumnConfig aColumn : this.columns) {
            if (aColumn.hasDefaultValue()) {
                DropDefaultValueChange dropChange = new DropDefaultValueChange();
                dropChange.setTableName(this.getTableName());
                dropChange.setColumnName(aColumn.getName());
                inverses.add(dropChange);
            }
            DropColumnChange inverse = new DropColumnChange();
            inverse.setSchemaName(this.getSchemaName());
            inverse.setColumnName(aColumn.getName());
            inverse.setTableName(this.getTableName());
            inverses.add(inverse);
        }
        return inverses.toArray(new Change[inverses.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        ArrayList<String> names = new ArrayList<String>(this.columns.size());
        for (ColumnConfig col : this.columns) {
            names.add(new StringBuffer().append(col.getName()).append("(").append(col.getType()).append(")").toString());
        }
        return new StringBuffer().append("Columns ").append(StringUtils.join(names, ",")).append(" added to ").append(this.tableName).toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement("addColumn");
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        node.setAttribute("tableName", this.getTableName());
        for (ColumnConfig col : this.getColumns()) {
            Element subNode = col.createNode(currentChangeLogFileDOM);
            node.appendChild(subNode);
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        ArrayList<DatabaseObject> result = new ArrayList<DatabaseObject>(this.columns.size());
        Table table = new Table(this.getTableName());
        result.add(table);
        for (ColumnConfig aColumn : this.columns) {
            Column each = new Column();
            each.setTable(table);
            each.setName(aColumn.getName());
            result.add(each);
        }
        return new HashSet<DatabaseObject>(result);
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

