/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddForeignKeyConstraintStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Integer;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddForeignKeyConstraintChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private String baseColumnNames;
    private String referencedTableSchemaName;
    private String referencedTableName;
    private String referencedColumnNames;
    private String constraintName;
    private Boolean deferrable;
    private Boolean initiallyDeferred;
    private Integer updateRule;
    private Integer deleteRule;

    public AddForeignKeyConstraintChange() {
        super("addForeignKeyConstraint", "Add Foreign Key Constraint");
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String baseTableSchemaName) {
        this.baseTableSchemaName = baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public String getBaseColumnNames() {
        return this.baseColumnNames;
    }

    public void setBaseColumnNames(String baseColumnNames) {
        this.baseColumnNames = baseColumnNames;
    }

    public String getReferencedTableSchemaName() {
        return this.referencedTableSchemaName;
    }

    public void setReferencedTableSchemaName(String referencedTableSchemaName) {
        this.referencedTableSchemaName = referencedTableSchemaName;
    }

    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    public void setReferencedTableName(String referencedTableName) {
        this.referencedTableName = referencedTableName;
    }

    public String getReferencedColumnNames() {
        return this.referencedColumnNames;
    }

    public void setReferencedColumnNames(String referencedColumnNames) {
        this.referencedColumnNames = referencedColumnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public Boolean getDeferrable() {
        return this.deferrable;
    }

    public void setDeferrable(Boolean deferrable) {
        this.deferrable = deferrable;
    }

    public Boolean getInitiallyDeferred() {
        return this.initiallyDeferred;
    }

    public void setInitiallyDeferred(Boolean initiallyDeferred) {
        this.initiallyDeferred = initiallyDeferred;
    }

    public void setDeleteCascade(Boolean deleteCascade) {
        if (deleteCascade != null && deleteCascade.booleanValue()) {
            this.setOnDelete("CASCADE");
        }
    }

    public void setUpdateRule(Integer rule) {
        this.updateRule = rule;
    }

    public Integer getUpdateRule() {
        return this.updateRule;
    }

    public void setDeleteRule(Integer rule) {
        this.deleteRule = rule;
    }

    public Integer getDeleteRule() {
        return this.deleteRule;
    }

    public void setOnDelete(String onDelete) {
        if (onDelete != null && onDelete.equalsIgnoreCase("CASCADE")) {
            this.setDeleteRule(_Integer.valueOf(0));
        } else if (onDelete != null && onDelete.equalsIgnoreCase("SET NULL")) {
            this.setDeleteRule(_Integer.valueOf(2));
        } else if (onDelete != null && onDelete.equalsIgnoreCase("SET DEFAULT")) {
            this.setDeleteRule(_Integer.valueOf(4));
        } else if (onDelete != null && onDelete.equalsIgnoreCase("RESTRICT")) {
            this.setDeleteRule(_Integer.valueOf(1));
        } else if (onDelete == null || onDelete.equalsIgnoreCase("NO ACTION")) {
            this.setDeleteRule(_Integer.valueOf(3));
        } else {
            throw new RuntimeException(new StringBuffer().append("Unknown onDelete action: ").append(onDelete).toString());
        }
    }

    public void setOnUpdate(String onUpdate) {
        if (onUpdate != null && onUpdate.equalsIgnoreCase("CASCADE")) {
            this.setUpdateRule(_Integer.valueOf(0));
        } else if (onUpdate != null && onUpdate.equalsIgnoreCase("SET NULL")) {
            this.setUpdateRule(_Integer.valueOf(2));
        } else if (onUpdate != null && onUpdate.equalsIgnoreCase("SET DEFAULT")) {
            this.setUpdateRule(_Integer.valueOf(4));
        } else if (onUpdate != null && onUpdate.equalsIgnoreCase("RESTRICT")) {
            this.setUpdateRule(_Integer.valueOf(1));
        } else if (onUpdate == null || onUpdate.equalsIgnoreCase("NO ACTION")) {
            this.setUpdateRule(_Integer.valueOf(3));
        } else {
            throw new RuntimeException(new StringBuffer().append("Unknown onUpdate action: ").append(onUpdate).toString());
        }
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.baseTableName) == null) {
            throw new InvalidChangeDefinitionException("baseTableName is required", this);
        }
        if (StringUtils.trimToNull(this.baseColumnNames) == null) {
            throw new InvalidChangeDefinitionException("baseColumnNames is required", this);
        }
        if (StringUtils.trimToNull(this.referencedTableName) == null) {
            throw new InvalidChangeDefinitionException("referencedTableName is required", this);
        }
        if (StringUtils.trimToNull(this.referencedColumnNames) == null) {
            throw new InvalidChangeDefinitionException("referenceColumnNames is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        boolean deferrable = false;
        if (this.getDeferrable() != null) {
            deferrable = this.getDeferrable();
        }
        boolean initiallyDeferred = false;
        if (this.getInitiallyDeferred() != null) {
            initiallyDeferred = this.getInitiallyDeferred();
        }
        return new SqlStatement[]{new AddForeignKeyConstraintStatement(this.getConstraintName(), this.getBaseTableSchemaName() == null ? database.getDefaultSchemaName() : this.getBaseTableSchemaName(), this.getBaseTableName(), this.getBaseColumnNames(), this.getReferencedTableSchemaName() == null ? database.getDefaultSchemaName() : this.getReferencedTableSchemaName(), this.getReferencedTableName(), this.getReferencedColumnNames()).setDeferrable(deferrable).setInitiallyDeferred(initiallyDeferred).setUpdateRule(this.updateRule).setDeleteRule(this.deleteRule)};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        return new SqlStatement[0];
    }

    @Override
    protected Change[] createInverses() {
        DropForeignKeyConstraintChange inverse = new DropForeignKeyConstraintChange();
        inverse.setBaseTableSchemaName(this.getBaseTableSchemaName());
        inverse.setBaseTableName(this.getBaseTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Foreign key contraint added to ").append(this.getBaseTableName()).append(" (").append(this.getBaseColumnNames()).append(")").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getBaseTableSchemaName() != null) {
            node.setAttribute("baseTableSchemaName", this.getBaseTableSchemaName());
        }
        node.setAttribute("baseTableName", this.getBaseTableName());
        node.setAttribute("baseColumnNames", this.getBaseColumnNames());
        node.setAttribute("constraintName", this.getConstraintName());
        if (this.getReferencedTableSchemaName() != null) {
            node.setAttribute("referencedTableSchemaName", this.getReferencedTableSchemaName());
        }
        node.setAttribute("referencedTableName", this.getReferencedTableName());
        node.setAttribute("referencedColumnNames", this.getReferencedColumnNames());
        if (this.getDeferrable() != null) {
            node.setAttribute("deferrable", this.getDeferrable().toString());
        }
        if (this.getInitiallyDeferred() != null) {
            node.setAttribute("initiallyDeferred", this.getInitiallyDeferred().toString());
        }
        if (this.getUpdateRule() != null) {
            switch (this.getUpdateRule()) {
                case 0: {
                    node.setAttribute("onUpdate", "CASCADE");
                    break;
                }
                case 2: {
                    node.setAttribute("onUpdate", "SET NULL");
                    break;
                }
                case 4: {
                    node.setAttribute("onUpdate", "SET DEFAULT");
                    break;
                }
                case 1: {
                    node.setAttribute("onUpdate", "RESTRICT");
                    break;
                }
            }
        }
        if (this.getDeleteRule() != null) {
            switch (this.getDeleteRule()) {
                case 0: {
                    node.setAttribute("onDelete", "CASCADE");
                    break;
                }
                case 2: {
                    node.setAttribute("onDelete", "SET NULL");
                    break;
                }
                case 4: {
                    node.setAttribute("onDelete", "SET DEFAULT");
                    break;
                }
                case 1: {
                    node.setAttribute("onDelete", "RESTRICT");
                    break;
                }
            }
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Table baseTable = new Table(this.getBaseTableName());
        returnSet.add(baseTable);
        for (String columnName : this.getBaseColumnNames().split(",")) {
            Column baseColumn = new Column();
            baseColumn.setTable(baseTable);
            baseColumn.setName(columnName.trim());
            returnSet.add(baseColumn);
        }
        Table referencedTable = new Table(this.getReferencedTableName());
        returnSet.add(referencedTable);
        for (String columnName : this.getReferencedColumnNames().split(",")) {
            Column referencedColumn = new Column();
            referencedColumn.setTable(baseTable);
            referencedColumn.setName(columnName.trim());
            returnSet.add(referencedColumn);
        }
        ForeignKey fk = new ForeignKey();
        fk.setName(this.constraintName);
        fk.setForeignKeyTable(baseTable);
        fk.setForeignKeyColumns(this.baseColumnNames);
        fk.setPrimaryKeyTable(referencedTable);
        fk.setPrimaryKeyColumns(this.referencedColumnNames);
        fk.setDeleteRule(this.deleteRule);
        fk.setUpdateRule(this.updateRule);
        returnSet.add(fk);
        return returnSet;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

