/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DropTableChange;
import liquibase.database.Database;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.CreateTableStatement;
import liquibase.database.sql.ForeignKeyConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.SetColumnRemarksStatement;
import liquibase.database.sql.SetTableRemarksStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UniqueConstraint;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableChange
extends AbstractChange
implements ChangeWithColumns {
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();
    private String schemaName;
    private String tableName;
    private String tablespace;
    private String remarks;

    public CreateTableChange() {
        super("createTable", "Create Table");
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (this.getColumns().size() == 0) {
            throw new InvalidChangeDefinitionException("No columns defined", this);
        }
        for (ColumnConfig column : this.getColumns()) {
            if (StringUtils.trimToNull(column.getName()) == null) {
                throw new InvalidChangeDefinitionException("Column name is required", this);
            }
            if (StringUtils.trimToNull(column.getType()) != null) continue;
            throw new InvalidChangeDefinitionException("Column type is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        SetTableRemarksStatement remarksStatement;
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        CreateTableStatement statement = new CreateTableStatement(schemaName, this.getTableName());
        for (ColumnConfig column : this.getColumns()) {
            ConstraintsConfig constraints = column.getConstraints();
            boolean isAutoIncrement = column.isAutoIncrement() != null && column.isAutoIncrement() != false;
            String defaultValue = null;
            if (column.hasDefaultValue()) {
                defaultValue = StringUtils.trimToNull(column.getDefaultColumnValue(database));
            }
            if (constraints != null && constraints.isPrimaryKey() != null && constraints.isPrimaryKey().booleanValue()) {
                statement.addPrimaryKeyColumn(column.getName(), database.getColumnType(column.getType(), isAutoIncrement), defaultValue, constraints.getPrimaryKeyName(), new ColumnConstraint[0]);
            } else {
                statement.addColumn(column.getName(), database.getColumnType(column.getType(), column.isAutoIncrement()), defaultValue);
            }
            if (constraints != null) {
                if (constraints.isNullable() != null && !constraints.isNullable().booleanValue()) {
                    statement.addColumnConstraint(new NotNullConstraint(column.getName()));
                }
                if (constraints.getReferences() != null) {
                    if (StringUtils.trimToNull(constraints.getForeignKeyName()) == null) {
                        throw new UnsupportedChangeException("createTable with references requires foreignKeyName");
                    }
                    ForeignKeyConstraint fkConstraint = new ForeignKeyConstraint(constraints.getForeignKeyName(), constraints.getReferences());
                    fkConstraint.setColumn(column.getName());
                    fkConstraint.setDeleteCascade(constraints.isDeleteCascade() != null && constraints.isDeleteCascade() != false);
                    fkConstraint.setInitiallyDeferred(constraints.isInitiallyDeferred() != null && constraints.isInitiallyDeferred() != false);
                    fkConstraint.setDeferrable(constraints.isDeferrable() != null && constraints.isDeferrable() != false);
                    statement.addColumnConstraint(fkConstraint);
                }
                if (constraints.isUnique() != null && constraints.isUnique().booleanValue()) {
                    statement.addColumnConstraint(new UniqueConstraint(constraints.getUniqueConstraintName()).addColumns(new String[]{column.getName()}));
                }
            }
            if (!isAutoIncrement) continue;
            statement.addColumnConstraint(new AutoIncrementConstraint(column.getName()));
        }
        statement.setTablespace(StringUtils.trimToNull(this.getTablespace()));
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        statements.add(statement);
        if (StringUtils.trimToNull(this.remarks) != null && (remarksStatement = new SetTableRemarksStatement(schemaName, this.tableName, this.remarks)).supportsDatabase(database)) {
            statements.add(remarksStatement);
        }
        for (ColumnConfig column : this.getColumns()) {
            SetColumnRemarksStatement remarksStatement2;
            String columnRemarks = StringUtils.trimToNull(column.getRemarks());
            if (columnRemarks == null || !(remarksStatement2 = new SetColumnRemarksStatement(schemaName, this.tableName, column.getName(), columnRemarks)).supportsDatabase(database)) continue;
            statements.add(remarksStatement2);
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropTableChange inverse = new DropTableChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        return new Change[]{inverse};
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Table ").append(this.tableName).append(" created").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement("createTable");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        if (StringUtils.trimToNull(this.tablespace) != null) {
            element.setAttribute("tablespace", this.tablespace);
        }
        if (StringUtils.trimToNull(this.remarks) != null) {
            element.setAttribute("remarks", this.remarks);
        }
        for (ColumnConfig column : this.getColumns()) {
            element.appendChild(column.createNode(currentChangeLogFileDOM));
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getTableName());
        returnSet.add(table);
        for (ColumnConfig columnConfig : this.getColumns()) {
            Column column = new Column();
            column.setTable(table);
            column.setName(columnConfig.getName());
            returnSet.add(column);
        }
        return returnSet;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

