/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.sql.InsertStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertDataChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public InsertDataChange() {
        super("insert", "Insert Row");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig column : this.getColumns()) {
            if (StringUtils.trimToNull(column.getName()) != null) continue;
            throw new InvalidChangeDefinitionException("column name is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        InsertStatement statement = new InsertStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName());
        for (ColumnConfig column : this.columns) {
            statement.addColumnValue(column.getName(), column.getValueObject());
        }
        return new SqlStatement[]{statement};
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("New row inserted into ").append(this.getTableName()).toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement("insert");
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        node.setAttribute("tableName", this.getTableName());
        for (ColumnConfig col : this.getColumns()) {
            Element subNode = col.createNode(currentChangeLogFileDOM);
            node.appendChild(subNode);
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table dbObject = new Table(this.getTableName());
        return new HashSet<DatabaseObject>(Arrays.asList(dbObject));
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

