/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import liquibase.FileOpener;
import liquibase.util.StreamUtil;

public class ChangeLogWriter {
    protected File outputDir;
    private FileOpener fileOpener;

    public ChangeLogWriter(FileOpener fileOpener, File rootOutputDir) {
        this.outputDir = new File(rootOutputDir, "changelogs");
        this.fileOpener = fileOpener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChangeLog(String changeLog, String physicalFilePath) throws IOException {
        InputStream stylesheet = this.fileOpener.getResourceAsStream(physicalFilePath);
        if (stylesheet == null) {
            throw new IOException("Can not find " + changeLog);
        }
        File xmlFile = new File(this.outputDir, changeLog + ".xml");
        xmlFile.getParentFile().mkdirs();
        FileOutputStream changeLogStream = new FileOutputStream(xmlFile, false);
        try {
            StreamUtil.copy(stylesheet, changeLogStream);
        }
        finally {
            changeLogStream.close();
        }
    }
}

