/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.visitor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.ChangeSet;
import liquibase.FileOpener;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.dbdoc.AuthorListWriter;
import liquibase.dbdoc.AuthorWriter;
import liquibase.dbdoc.ChangeLogListWriter;
import liquibase.dbdoc.ChangeLogWriter;
import liquibase.dbdoc.ColumnWriter;
import liquibase.dbdoc.PendingChangesWriter;
import liquibase.dbdoc.PendingSQLWriter;
import liquibase.dbdoc.RecentChangesWriter;
import liquibase.dbdoc.TableListWriter;
import liquibase.dbdoc.TableWriter;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.JDBCException;
import liquibase.exception.LiquibaseException;
import liquibase.parser.visitor.ChangeSetVisitor;
import liquibase.util.StreamUtil;

public class DBDocVisitor
implements ChangeSetVisitor {
    private Database database;
    private SortedSet<ChangeLogInfo> changeLogs;
    private Map<DatabaseObject, List<Change>> changesByObject;
    private Map<String, List<Change>> changesByAuthor;
    private Map<DatabaseObject, List<Change>> changesToRunByObject;
    private Map<String, List<Change>> changesToRunByAuthor;
    private List<Change> changesToRun;
    private List<Change> recentChanges;
    private String rootChangeLog;
    private static final int MAX_RECENT_CHANGE = 50;

    public DBDocVisitor(Database database) {
        this.database = database;
        this.changesByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesByAuthor = new HashMap<String, List<Change>>();
        this.changeLogs = new TreeSet<ChangeLogInfo>();
        this.changesToRunByObject = new HashMap<DatabaseObject, List<Change>>();
        this.changesToRunByAuthor = new HashMap<String, List<Change>>();
        this.changesToRun = new ArrayList<Change>();
        this.recentChanges = new ArrayList<Change>();
    }

    public ChangeSetVisitor.Direction getDirection() {
        return ChangeSetVisitor.Direction.FORWARD;
    }

    public void visit(ChangeSet changeSet, Database database) throws LiquibaseException {
        ChangeSet.RunStatus runStatus = this.database.getRunStatus(changeSet);
        if (this.rootChangeLog == null) {
            this.rootChangeLog = changeSet.getFilePath();
        }
        if (!this.changesByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        if (!this.changesToRunByAuthor.containsKey(changeSet.getAuthor())) {
            this.changesToRunByAuthor.put(changeSet.getAuthor(), new ArrayList());
        }
        boolean toRun = runStatus.equals(ChangeSet.RunStatus.NOT_RAN) || runStatus.equals(ChangeSet.RunStatus.RUN_AGAIN);
        Iterator<Change> i$ = changeSet.getChanges().iterator();
        while (i$.hasNext()) {
            Change change = i$.next();
            if (toRun) {
                this.changesToRunByAuthor.get(changeSet.getAuthor()).add(change);
                this.changesToRun.add(change);
                continue;
            }
            this.changesByAuthor.get(changeSet.getAuthor()).add(change);
            this.recentChanges.add(0, change);
        }
        ChangeLogInfo changeLogInfo = new ChangeLogInfo(changeSet.getFilePath(), changeSet.getPhysicalFilePath());
        if (!this.changeLogs.contains(changeLogInfo)) {
            this.changeLogs.add(changeLogInfo);
        }
        Iterator<Change> i$2 = changeSet.getChanges().iterator();
        while (i$2.hasNext()) {
            Change change = i$2.next();
            Set<DatabaseObject> affectedDatabaseObjects = change.getAffectedDatabaseObjects();
            if (affectedDatabaseObjects == null) continue;
            Iterator<DatabaseObject> i$3 = affectedDatabaseObjects.iterator();
            while (i$3.hasNext()) {
                DatabaseObject dbObject = i$3.next();
                if (toRun) {
                    if (!this.changesToRunByObject.containsKey(dbObject)) {
                        this.changesToRunByObject.put(dbObject, new ArrayList());
                    }
                    this.changesToRunByObject.get(dbObject).add(change);
                }
                if (!this.changesByObject.containsKey(dbObject)) {
                    this.changesByObject.put(dbObject, new ArrayList());
                }
                this.changesByObject.get(dbObject).add(change);
            }
        }
    }

    public void writeHTML(File rootOutputDir, FileOpener fileOpener) throws IOException, JDBCException, DatabaseHistoryException {
        ChangeLogWriter changeLogWriter = new ChangeLogWriter(fileOpener, rootOutputDir);
        AuthorWriter authorWriter = new AuthorWriter(rootOutputDir, this.database);
        TableWriter tableWriter = new TableWriter(rootOutputDir, this.database);
        ColumnWriter columnWriter = new ColumnWriter(rootOutputDir, this.database);
        PendingChangesWriter pendingChangesWriter = new PendingChangesWriter(rootOutputDir, this.database);
        RecentChangesWriter recentChangesWriter = new RecentChangesWriter(rootOutputDir, this.database);
        PendingSQLWriter pendingSQLWriter = new PendingSQLWriter(rootOutputDir, this.database);
        this.copyFile("liquibase/dbdoc/stylesheet.css", rootOutputDir);
        this.copyFile("liquibase/dbdoc/index.html", rootOutputDir);
        this.copyFile("liquibase/dbdoc/globalnav.html", rootOutputDir);
        this.copyFile("liquibase/dbdoc/overview-summary.html", rootOutputDir);
        DatabaseSnapshot snapshot = this.database.createDatabaseSnapshot(null, null);
        new ChangeLogListWriter(rootOutputDir).writeHTML(this.changeLogs);
        new TableListWriter(rootOutputDir).writeHTML(new TreeSet<Table>(snapshot.getTables()));
        new AuthorListWriter(rootOutputDir).writeHTML(new TreeSet<String>(this.changesByAuthor.keySet()));
        Iterator<Object> i$ = this.changesByAuthor.keySet().iterator();
        while (i$.hasNext()) {
            String author = i$.next();
            authorWriter.writeHTML(author, this.changesByAuthor.get(author), this.changesToRunByAuthor.get(author), this.rootChangeLog);
        }
        i$ = snapshot.getTables().iterator();
        while (i$.hasNext()) {
            Table table = (Table)i$.next();
            tableWriter.writeHTML(table, this.changesByObject.get(table), this.changesToRunByObject.get(table), this.rootChangeLog);
        }
        i$ = snapshot.getColumns().iterator();
        while (i$.hasNext()) {
            Column column = (Column)i$.next();
            columnWriter.writeHTML(column, this.changesByObject.get(column), this.changesToRunByObject.get(column), this.rootChangeLog);
        }
        i$ = this.changeLogs.iterator();
        while (i$.hasNext()) {
            ChangeLogInfo changeLog = (ChangeLogInfo)i$.next();
            changeLogWriter.writeChangeLog(changeLog.logicalPath, changeLog.physicalPath);
        }
        pendingChangesWriter.writeHTML("index", null, this.changesToRun, this.rootChangeLog);
        pendingSQLWriter.writeHTML("sql", null, this.changesToRun, this.rootChangeLog);
        if (this.recentChanges.size() > 50) {
            this.recentChanges = this.recentChanges.subList(0, 50);
        }
        recentChangesWriter.writeHTML("index", this.recentChanges, null, this.rootChangeLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(String fileToCopy, File rootOutputDir) throws IOException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fileToCopy);
        FileOutputStream outputStream = null;
        try {
            if (inputStream == null) {
                throw new IOException("Can not find " + fileToCopy);
            }
            outputStream = new FileOutputStream(new File(rootOutputDir, fileToCopy.replaceFirst(".*\\/", "")), false);
            StreamUtil.copy(inputStream, outputStream);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeLogInfo
    implements Comparable<ChangeLogInfo> {
        public String logicalPath;
        public String physicalPath;

        private ChangeLogInfo(String logicalPath, String physicalPath) {
            this.logicalPath = logicalPath;
            this.physicalPath = physicalPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ChangeLogInfo that = (ChangeLogInfo)o;
            return this.logicalPath.equals(that.logicalPath);
        }

        public int hashCode() {
            return this.logicalPath.hashCode();
        }

        @Override
        public int compareTo(ChangeLogInfo o) {
            return this.logicalPath.compareTo(o.logicalPath);
        }

        public String toString() {
            return this.logicalPath;
        }

        @Override
        public /* synthetic */ int compareTo(Object x0) {
            return this.compareTo((ChangeLogInfo)x0);
        }
    }
}

