/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Byte;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Double;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Float;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Integer;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Long;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Short;

public abstract class NumberUtils {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$math$BigInteger;

    public static Number convertNumberToTargetClass(Number number, Class targetClass) throws IllegalArgumentException {
        if (targetClass.isInstance(number)) {
            return number;
        }
        Class<?> clazz = class$java$lang$Byte;
        if (clazz == null) {
            clazz = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz)) {
            long value = number.longValue();
            if (value < -128L || value > 127L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return _Byte.valueOf(number.byteValue());
        }
        Class<?> clazz2 = class$java$lang$Short;
        if (clazz2 == null) {
            clazz2 = class$java$lang$Short = new Short[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz2)) {
            long value = number.longValue();
            if (value < -32768L || value > 32767L) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return _Short.valueOf(number.shortValue());
        }
        Class<?> clazz3 = class$java$lang$Integer;
        if (clazz3 == null) {
            clazz3 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz3)) {
            long value = number.longValue();
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                NumberUtils.raiseOverflowException(number, targetClass);
            }
            return _Integer.valueOf(number.intValue());
        }
        Class<?> clazz4 = class$java$lang$Long;
        if (clazz4 == null) {
            clazz4 = class$java$lang$Long = new Long[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz4)) {
            return _Long.valueOf(number.longValue());
        }
        Class<?> clazz5 = class$java$lang$Float;
        if (clazz5 == null) {
            clazz5 = class$java$lang$Float = new Float[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz5)) {
            return _Float.valueOf(number.floatValue());
        }
        Class<?> clazz6 = class$java$lang$Double;
        if (clazz6 == null) {
            clazz6 = class$java$lang$Double = new Double[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz6)) {
            return _Double.valueOf(number.doubleValue());
        }
        Class<?> clazz7 = class$java$math$BigInteger;
        if (clazz7 == null) {
            clazz7 = class$java$math$BigInteger = new BigInteger[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz7)) {
            return BigInteger.valueOf(number.longValue());
        }
        Class<?> clazz8 = class$java$math$BigDecimal;
        if (clazz8 == null) {
            clazz8 = class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType();
        }
        if (targetClass.equals(clazz8)) {
            return new BigDecimal(number.toString());
        }
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to unknown target class [" + targetClass.getName() + "]");
    }

    private static void raiseOverflowException(Number number, Class targetClass) {
        throw new IllegalArgumentException("Could not convert number [" + number + "] of type [" + number.getClass().getName() + "] to target class [" + targetClass.getName() + "]: overflow");
    }

    public static Number parseNumber(String text, Class targetClass) {
        block20: {
            String trimmed;
            block19: {
                trimmed = text.trim();
                Class<?> clazz = class$java$lang$Byte;
                if (clazz == null) {
                    clazz = class$java$lang$Byte = new Byte[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz)) {
                    return Byte.decode(trimmed);
                }
                Class<?> clazz2 = class$java$lang$Short;
                if (clazz2 == null) {
                    clazz2 = class$java$lang$Short = new Short[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz2)) {
                    return Short.decode(trimmed);
                }
                Class<?> clazz3 = class$java$lang$Integer;
                if (clazz3 == null) {
                    clazz3 = class$java$lang$Integer = new Integer[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz3)) {
                    return Integer.decode(trimmed);
                }
                Class<?> clazz4 = class$java$lang$Long;
                if (clazz4 == null) {
                    clazz4 = class$java$lang$Long = new Long[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz4)) {
                    return Long.decode(trimmed);
                }
                Class<?> clazz5 = class$java$math$BigInteger;
                if (clazz5 == null) {
                    clazz5 = class$java$math$BigInteger = new BigInteger[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz5)) {
                    return NumberUtils.decodeBigInteger(trimmed);
                }
                Class<?> clazz6 = class$java$lang$Float;
                if (clazz6 == null) {
                    clazz6 = class$java$lang$Float = new Float[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz6)) {
                    return Float.valueOf(trimmed);
                }
                Class<?> clazz7 = class$java$lang$Double;
                if (clazz7 == null) {
                    clazz7 = class$java$lang$Double = new Double[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz7)) {
                    return Double.valueOf(trimmed);
                }
                Class<?> clazz8 = class$java$math$BigDecimal;
                if (clazz8 == null) {
                    clazz8 = class$java$math$BigDecimal = new BigDecimal[0].getClass().getComponentType();
                }
                if (targetClass.equals(clazz8)) break block19;
                Class<?> clazz9 = class$java$lang$Number;
                if (clazz9 == null) {
                    clazz9 = class$java$lang$Number = new Number[0].getClass().getComponentType();
                }
                if (!targetClass.equals(clazz9)) break block20;
            }
            return new BigDecimal(trimmed);
        }
        throw new IllegalArgumentException("Cannot convert String [" + text + "] to target class [" + targetClass.getName() + "]");
    }

    public static Number parseNumber(String text, Class targetClass, NumberFormat numberFormat) {
        if (numberFormat != null) {
            try {
                Number number = numberFormat.parse(text.trim());
                return NumberUtils.convertNumberToTargetClass(number, targetClass);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(ex.getMessage());
            }
        }
        return NumberUtils.parseNumber(text, targetClass);
    }

    private static BigInteger decodeBigInteger(String value) {
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (value.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (value.startsWith("0x", index) || value.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (value.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (value.startsWith("0", index) && value.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        BigInteger result = new BigInteger(value.substring(index), radix);
        return negative ? result.negate() : result;
    }
}

