/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.DatabaseChangeLogLock;
import liquibase.FileOpener;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.template.JdbcOutputTemplate;
import liquibase.database.template.JdbcTemplate;
import liquibase.exception.JDBCException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.lock.LockHandler;
import liquibase.log.LogFactory;
import liquibase.parser.ChangeLogIterator;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.filter.AfterTagChangeSetFilter;
import liquibase.parser.filter.AlreadyRanChangeSetFilter;
import liquibase.parser.filter.ChangeSetFilter;
import liquibase.parser.filter.ContextChangeSetFilter;
import liquibase.parser.filter.CountChangeSetFilter;
import liquibase.parser.filter.DbmsChangeSetFilter;
import liquibase.parser.filter.ExecutedAfterChangeSetFilter;
import liquibase.parser.filter.NotRanChangeSetFilter;
import liquibase.parser.filter.ShouldRunChangeSetFilter;
import liquibase.parser.visitor.ChangeLogSyncVisitor;
import liquibase.parser.visitor.DBDocVisitor;
import liquibase.parser.visitor.ListVisitor;
import liquibase.parser.visitor.RollbackVisitor;
import liquibase.parser.visitor.UpdateVisitor;
import liquibase.retro.net.sf.retrotranslator.runtime.java.io._Writer;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Liquibase {
    public static final String SHOULD_RUN_SYSTEM_PROPERTY = "liquibase.should.run";
    private String changeLogFile;
    private FileOpener fileOpener;
    private Database database;
    private Logger log;
    private Map<String, Object> changeLogParameters = new HashMap<String, Object>();

    public Liquibase(String changeLogFile, FileOpener fileOpener, Connection conn) throws JDBCException {
        this(changeLogFile, fileOpener, DatabaseFactory.getInstance().findCorrectDatabaseImplementation(conn));
    }

    public Liquibase(String changeLogFile, FileOpener fileOpener, Database database) {
        this.log = LogFactory.getLogger();
        if (changeLogFile != null) {
            this.changeLogFile = changeLogFile.replace('\\', '/');
        }
        this.fileOpener = fileOpener;
        this.database = database;
    }

    public Database getDatabase() {
        return this.database;
    }

    public FileOpener getFileOpener() {
        return this.fileOpener;
    }

    public void setCurrentDateTimeFunction(String currentDateTimeFunction) {
        if (currentDateTimeFunction != null) {
            this.database.setCurrentDateTimeFunction(currentDateTimeFunction);
        }
    }

    public Object getChangeLogParameterValue(String paramter) {
        return this.changeLogParameters.get(paramter);
    }

    public void setChangeLogParameterValue(String paramter, Object value) {
        if (!this.changeLogParameters.containsKey(paramter)) {
            this.changeLogParameters.put(paramter, value);
        }
    }

    public void update(String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database)});
            logIterator.run(new UpdateVisitor(this.database), this.database);
        }
        catch (LiquibaseException e) {
            throw e;
        }
        finally {
            try {
                lockHandler.releaseLock();
            }
            catch (LockException e) {
                this.log.log(Level.SEVERE, "Could not release lock", e);
            }
        }
    }

    public void update(String contexts, Writer output) throws LiquibaseException {
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        JdbcOutputTemplate outputTemplate = new JdbcOutputTemplate(output, this.database);
        this.database.setJdbcTemplate(outputTemplate);
        this.outputHeader("Update Database Script");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.update(contexts);
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        finally {
            lockHandler.releaseLock();
        }
        this.database.setJdbcTemplate(oldTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int changesToApply, String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(changesToApply)});
            logIterator.run(new UpdateVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void update(int changesToApply, String contexts, Writer output) throws LiquibaseException {
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        JdbcOutputTemplate outputTemplate = new JdbcOutputTemplate(output, this.database);
        this.database.setJdbcTemplate(outputTemplate);
        this.outputHeader(new StringBuffer().append("Update ").append(changesToApply).append(" Change Sets Database Script").toString());
        this.update(changesToApply, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        this.database.setJdbcTemplate(oldTemplate);
    }

    private void outputHeader(String message) throws JDBCException {
        this.database.getJdbcTemplate().comment("*********************************************************************");
        this.database.getJdbcTemplate().comment(message);
        this.database.getJdbcTemplate().comment("*********************************************************************");
        this.database.getJdbcTemplate().comment(new StringBuffer().append("Change Log: ").append(this.changeLogFile).toString());
        this.database.getJdbcTemplate().comment(new StringBuffer().append("Ran at: ").append(DateFormat.getDateTimeInstance(3, 3).format(new Date())).toString());
        this.database.getJdbcTemplate().comment(new StringBuffer().append("Against: ").append(this.getDatabase().getConnectionUsername()).append("@").append(this.getDatabase().getConnectionURL()).toString());
        this.database.getJdbcTemplate().comment(new StringBuffer().append("LiquiBase version: ").append(LiquibaseUtil.getBuildVersion()).toString());
        this.database.getJdbcTemplate().comment(new StringBuffer().append("*********************************************************************").append(StreamUtil.getLineSeparator()).toString());
    }

    public void rollback(int changesToRollback, String contexts, Writer output) throws LiquibaseException {
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(new JdbcOutputTemplate(output, this.database));
        this.outputHeader(new StringBuffer().append("Rollback ").append(changesToRollback).append(" Change(s) Script").toString());
        this.rollback(changesToRollback, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        this.database.setJdbcTemplate(oldTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(int changesToRollback, String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new AlreadyRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(changesToRollback)});
            logIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            try {
                lockHandler.releaseLock();
            }
            catch (LockException e) {
                this.log.log(Level.SEVERE, "Error releasing lock", e);
            }
        }
    }

    public void rollback(String tagToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(new JdbcOutputTemplate(output, this.database));
        this.outputHeader(new StringBuffer().append("Rollback to '").append(tagToRollBackTo).append("' Script").toString());
        this.rollback(tagToRollBackTo, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        this.database.setJdbcTemplate(oldTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(String tagToRollBackTo, String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new AfterTagChangeSetFilter(tagToRollBackTo, this.database.getRanChangeSetList()), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database)});
            logIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void rollback(Date dateToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(new JdbcOutputTemplate(output, this.database));
        this.outputHeader(new StringBuffer().append("Rollback to ").append(dateToRollBackTo).append(" Script").toString());
        this.rollback(dateToRollBackTo, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        this.database.setJdbcTemplate(oldTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Date dateToRollBackTo, String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ExecutedAfterChangeSetFilter(dateToRollBackTo, this.database.getRanChangeSetList()), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database)});
            logIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void changeLogSync(String contexts, Writer output) throws LiquibaseException {
        JdbcOutputTemplate outputTemplate = new JdbcOutputTemplate(output, this.database);
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(outputTemplate);
        this.outputHeader("SQL to add all changesets to database history table");
        this.changeLogSync(contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        this.database.setJdbcTemplate(oldTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLogSync(String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database)});
            logIterator.run(new ChangeLogSyncVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void markNextChangeSetRan(String contexts, Writer output) throws LiquibaseException {
        JdbcOutputTemplate outputTemplate = new JdbcOutputTemplate(output, this.database);
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(outputTemplate);
        this.outputHeader("SQL to add all changesets to database history table");
        this.markNextChangeSetRan(contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        this.database.setJdbcTemplate(oldTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markNextChangeSetRan(String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(1)});
            logIterator.run(new ChangeLogSyncVisitor(this.database), this.database);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureRollbackSQL(String contexts, Writer output) throws LiquibaseException {
        JdbcOutputTemplate outputTemplate = new JdbcOutputTemplate(output, this.database);
        JdbcTemplate oldTemplate = this.database.getJdbcTemplate();
        this.database.setJdbcTemplate(outputTemplate);
        this.outputHeader("SQL to roll back currently unexecuted changes");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database)});
            logIterator.run(new RollbackVisitor(this.database), this.database);
        }
        finally {
            this.database.setJdbcTemplate(oldTemplate);
            lockHandler.releaseLock();
        }
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public final void dropAll() throws JDBCException, LockException {
        this.dropAll(new String[]{this.getDatabase().getDefaultSchemaName()});
    }

    public final void dropAll(String[] schemas) throws JDBCException {
        try {
            LockHandler.getInstance(this.database).waitForLock();
            for (String schema : schemas) {
                this.log.info(new StringBuffer().append("Dropping Database Objects in schema: ").append(this.database.convertRequestedSchemaToSchema(schema)).toString());
                this.checkDatabaseChangeLogTable();
                this.getDatabase().dropDatabaseObjects(schema);
                this.checkDatabaseChangeLogTable();
                this.log.finest("Objects dropped successfully");
            }
        }
        catch (JDBCException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JDBCException(e);
        }
        finally {
            try {
                LockHandler.getInstance(this.database).releaseLock();
            }
            catch (LockException e) {
                this.log.severe(new StringBuffer().append("Unable to release lock: ").append(e.getMessage()).toString());
            }
        }
    }

    public void tag(String tagString) throws JDBCException {
        this.getDatabase().tag(tagString);
    }

    public void checkDatabaseChangeLogTable() throws JDBCException {
        this.getDatabase().checkDatabaseChangeLogTable();
        this.getDatabase().checkDatabaseChangeLogLockTable();
    }

    public boolean isSafeToRunMigration() throws JDBCException {
        return !this.getDatabase().getJdbcTemplate().executesStatements() || this.getDatabase().isLocalDatabase();
    }

    public DatabaseChangeLogLock[] listLocks() throws JDBCException, IOException, LockException {
        this.checkDatabaseChangeLogTable();
        return LockHandler.getInstance(this.getDatabase()).listLocks();
    }

    public void reportLocks(PrintStream out) throws LockException, IOException, JDBCException {
        DatabaseChangeLogLock[] locks = this.listLocks();
        out.println(new StringBuffer().append("Database change log locks for ").append(this.getDatabase().getConnectionUsername()).append("@").append(this.getDatabase().getConnectionURL()).toString());
        if (locks.length == 0) {
            out.println(" - No locks");
        }
        for (DatabaseChangeLogLock lock : locks) {
            out.println(new StringBuffer().append(" - ").append(lock.getLockedBy()).append(" at ").append(DateFormat.getDateTimeInstance().format(lock.getLockGranted())).toString());
        }
    }

    public void forceReleaseLocks() throws LockException, IOException, JDBCException {
        this.checkDatabaseChangeLogTable();
        LockHandler.getInstance(this.getDatabase()).forceReleaseLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ChangeSet> listUnrunChangeSets(String contexts) throws LiquibaseException {
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new ShouldRunChangeSetFilter(this.database), new ContextChangeSetFilter(new String[]{contexts}), new DbmsChangeSetFilter(this.database)});
            ListVisitor visitor = new ListVisitor();
            logIterator.run(visitor, this.database);
            List<ChangeSet> list = visitor.getSeenChangeSets();
            return list;
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void reportStatus(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        try {
            List<ChangeSet> unrunChangeSets = this.listUnrunChangeSets(contexts);
            _Writer.append(out, String.valueOf(unrunChangeSets.size()));
            _Writer.append(out, " change sets have not been applied to ");
            _Writer.append(out, this.getDatabase().getConnectionUsername());
            _Writer.append(out, "@");
            _Writer.append(out, this.getDatabase().getConnectionURL());
            _Writer.append(out, StreamUtil.getLineSeparator());
            if (verbose) {
                for (ChangeSet changeSet : unrunChangeSets) {
                    _Writer.append(_Writer.append(_Writer.append(out, "     "), changeSet.toString(false)), StreamUtil.getLineSeparator());
                }
            }
            out.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCheckSums() throws LiquibaseException {
        this.log.info("Clearing database change log checksums");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            UpdateStatement updateStatement = new UpdateStatement(this.getDatabase().getDefaultSchemaName(), this.getDatabase().getDatabaseChangeLogTableName());
            updateStatement.addNewColumnValue("MD5SUM", null);
            this.getDatabase().getJdbcTemplate().execute(updateStatement, new ArrayList<SqlVisitor>());
            this.getDatabase().commit();
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void generateDocumentation(String outputDirectory) throws LiquibaseException {
        this.log.info("Generating Database Documentation");
        LockHandler lockHandler = LockHandler.getInstance(this.database);
        lockHandler.waitForLock();
        try {
            this.database.checkDatabaseChangeLogTable();
            DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
            changeLog.validate(this.database);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ChangeSetFilter[]{new DbmsChangeSetFilter(this.database)});
            DBDocVisitor visitor = new DBDocVisitor(this.database);
            logIterator.run(visitor, this.database);
            visitor.writeHTML(new File(outputDirectory), this.fileOpener);
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        finally {
            lockHandler.releaseLock();
        }
    }

    public void validate() throws LiquibaseException {
        DatabaseChangeLog changeLog = new ChangeLogParser(this.changeLogParameters).parse(this.changeLogFile, this.fileOpener);
        changeLog.validate(this.database);
    }
}

