/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.ChangeSet;
import liquibase.FileOpener;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.exception.JDBCException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.exception.SetupException;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.log.LogFactory;
import liquibase.retro.net.sf.retrotranslator.runtime.java.io._Writer;
import liquibase.util.MD5Util;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import liquibase.util.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChange
implements Change {
    private final String changeName;
    private final String tagName;
    private FileOpener fileOpener;
    private ChangeSet changeSet;

    protected AbstractChange(String tagName, String changeName) {
        this.tagName = tagName;
        this.changeName = changeName;
    }

    @Override
    public ChangeSet getChangeSet() {
        return this.changeSet;
    }

    @Override
    public void setChangeSet(ChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    @Override
    public String getChangeName() {
        return this.changeName;
    }

    @Override
    public String getTagName() {
        return this.tagName;
    }

    @Override
    public void executeStatements(Database database, List<SqlVisitor> sqlVisitors) throws JDBCException, UnsupportedChangeException {
        SqlStatement[] statements = this.generateStatements(database);
        this.execute(statements, sqlVisitors, database);
    }

    @Override
    public void saveStatements(Database database, List<SqlVisitor> sqlVisitors, Writer writer) throws IOException, UnsupportedChangeException, StatementNotSupportedOnDatabaseException {
        SqlStatement[] statements;
        for (SqlStatement statement : statements = this.generateStatements(database)) {
            _Writer.append(_Writer.append(_Writer.append(_Writer.append(writer, statement.getSqlStatement(database)), statement.getEndDelimiter(database)), StreamUtil.getLineSeparator()), StreamUtil.getLineSeparator());
        }
    }

    @Override
    public void executeRollbackStatements(Database database, List<SqlVisitor> sqlVisitors) throws JDBCException, UnsupportedChangeException, RollbackImpossibleException {
        SqlStatement[] statements = this.generateRollbackStatements(database);
        this.execute(statements, sqlVisitors, database);
    }

    @Override
    public void saveRollbackStatement(Database database, List<SqlVisitor> sqlVisitors, Writer writer) throws IOException, UnsupportedChangeException, RollbackImpossibleException, StatementNotSupportedOnDatabaseException {
        SqlStatement[] statements;
        for (SqlStatement statement : statements = this.generateRollbackStatements(database)) {
            _Writer.append(_Writer.append(writer, statement.getSqlStatement(database)), ";\n\n");
        }
    }

    @Override
    public SqlStatement[] generateRollbackStatements(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        return this.generateRollbackStatementsFromInverse(database);
    }

    @Override
    public boolean canRollBack() {
        return this.createInverses() != null;
    }

    @Override
    public String getMD5Sum() {
        try {
            StringBuffer buffer = new StringBuffer();
            this.nodeToStringBuffer(this.createNode(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()), buffer);
            return MD5Util.computeMD5(buffer.toString());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private SqlStatement[] generateRollbackStatementsFromInverse(Database database) throws UnsupportedChangeException, RollbackImpossibleException {
        Change[] inverses = this.createInverses();
        if (inverses == null) {
            throw new RollbackImpossibleException(new StringBuffer().append("No inverse to ").append(this.getClass().getName()).append(" created").toString());
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        for (Change inverse : inverses) {
            statements.addAll(Arrays.asList(inverse.generateStatements(database)));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    protected Change[] createInverses() {
        return null;
    }

    private void nodeToStringBuffer(Node node, StringBuffer buffer) {
        buffer.append("<").append(node.getNodeName());
        TreeMap<String, String> attributeMap = new TreeMap<String, String>();
        NamedNodeMap attributes = node.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            attributeMap.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        for (Map.Entry entry : attributeMap.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            buffer.append(" ").append(entry.getKey()).append("=\"").append(value).append("\"");
        }
        buffer.append(">").append(StringUtils.trimToEmpty(XMLUtil.getTextContent(node)));
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            this.nodeToStringBuffer((Element)childNode, buffer);
        }
        buffer.append("</").append(node.getNodeName()).append(">");
    }

    private void execute(SqlStatement[] statements, List<SqlVisitor> sqlVisitors, Database database) throws JDBCException {
        for (SqlStatement statement : statements) {
            LogFactory.getLogger().finest(new StringBuffer().append("Executing Statement: ").append(statement).toString());
            database.getJdbcTemplate().execute(statement, sqlVisitors);
        }
    }

    @Override
    public void setFileOpener(FileOpener fileOpener) {
        this.fileOpener = fileOpener;
    }

    public FileOpener getFileOpener() {
        return this.fileOpener;
    }

    @Override
    public void setUp() throws SetupException {
    }
}

