/*
 * Decompiled with CFR 0.152.
 */
package liquibase.commandline;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.HibernateDatabase;
import liquibase.diff.Diff;
import liquibase.diff.DiffResult;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.exception.MigrationFailedException;
import liquibase.log.LogFactory;
import liquibase.retro.net.sf.retrotranslator.runtime.java.io._PrintStream;
import liquibase.util.StringUtils;

public class CommandLineUtils {
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$liquibase$database$HibernateDatabase;

    public static Database createDatabaseObject(ClassLoader classLoader, String url, String username, String password, String driver, String defaultSchemaName, String databaseClass) throws JDBCException {
        if (driver == null) {
            driver = DatabaseFactory.getInstance().findDefaultDriver(url);
        }
        try {
            Connection connection;
            Driver driverObject;
            if (url.startsWith("hibernate:")) {
                try {
                    return CommandLineUtils.createHibernateDatabase(classLoader, url);
                }
                catch (NoClassDefFoundError e) {
                    try {
                        return CommandLineUtils.createHibernateDatabase(Thread.currentThread().getContextClassLoader(), url);
                    }
                    catch (NoClassDefFoundError e1) {
                        throw new MigrationFailedException(null, "Class " + e1.getMessage() + " not found.  Make sure all required Hibernate and JDBC libraries are in your classpath");
                    }
                }
            }
            DatabaseFactory databaseFactory = DatabaseFactory.getInstance();
            if (databaseClass != null) {
                databaseFactory.addDatabaseImplementation((Database)Class.forName(databaseClass, true, classLoader).newInstance());
            }
            try {
                if (driver == null) {
                    driver = databaseFactory.findDefaultDriver(url);
                }
                if (driver == null) {
                    throw new RuntimeException("Driver class was not specified and could not be determined from the url (" + url + ")");
                }
                driverObject = (Driver)Class.forName(driver, true, classLoader).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot find database driver: " + e.getMessage());
            }
            Properties info = new Properties();
            if (username != null) {
                info.put("user", username);
            }
            if (password != null) {
                info.put("password", password);
            }
            if ((connection = driverObject.connect(url, info)) == null) {
                throw new JDBCException("Connection could not be created to " + url + " with driver " + driver.getClass().getName() + ".  Possibly the wrong driver for the given database URL");
            }
            Database database = databaseFactory.findCorrectDatabaseImplementation(connection);
            database.setDefaultSchemaName(StringUtils.trimToNull(defaultSchemaName));
            return database;
        }
        catch (Exception e) {
            throw new JDBCException(e);
        }
    }

    private static Database createHibernateDatabase(ClassLoader classLoader, String url) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> clazz = class$liquibase$database$HibernateDatabase;
        if (clazz == null) {
            clazz = class$liquibase$database$HibernateDatabase = new HibernateDatabase[0].getClass().getComponentType();
        }
        Class<?> clazz2 = Class.forName(clazz.getName(), true, classLoader);
        Class[] classArray = new Class[1];
        Class<?> clazz3 = class$java$lang$String;
        if (clazz3 == null) {
            clazz3 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        classArray[0] = clazz3;
        return (Database)clazz2.getConstructor(classArray).newInstance(url.substring("hibernate:".length()));
    }

    public static void doDiff(Database baseDatabase, Database targetDatabase) throws JDBCException {
        Diff diff = new Diff(baseDatabase, targetDatabase);
        diff.addStatusListener(new OutDiffStatusListener());
        DiffResult diffResult = diff.compare();
        System.out.println("");
        System.out.println("Diff Results:");
        diffResult.printResult(System.out);
    }

    public static void doDiffToChangeLog(String changeLogFile, Database baseDatabase, Database targetDatabase) throws JDBCException, IOException, ParserConfigurationException {
        Diff diff = new Diff(baseDatabase, targetDatabase);
        diff.addStatusListener(new OutDiffStatusListener());
        DiffResult diffResult = diff.compare();
        if (changeLogFile == null) {
            diffResult.printChangeLog(System.out, targetDatabase);
        } else {
            diffResult.printChangeLog(changeLogFile, targetDatabase);
        }
    }

    public static void doGenerateChangeLog(String changeLogFile, Database originalDatabase, String defaultSchemaName, String diffTypes, String author, String context, String dataDir) throws JDBCException, IOException, ParserConfigurationException {
        Diff diff = new Diff(originalDatabase, defaultSchemaName);
        diff.setDiffTypes(diffTypes);
        diff.addStatusListener(new OutDiffStatusListener());
        DiffResult diffResult = diff.compare();
        diffResult.setChangeSetAuthor(author);
        diffResult.setChangeSetContext(context);
        diffResult.setDataDir(dataDir);
        PrintStream outputStream = System.out;
        if (StringUtils.trimToNull(changeLogFile) != null) {
            File changeFile = new File(changeLogFile);
            outputStream = new PrintStream(_PrintStream.convertConstructorArguments(changeFile));
        }
        diffResult.printChangeLog(outputStream, originalDatabase);
    }

    private static class OutDiffStatusListener
    implements DiffStatusListener {
        private Formatter customFormatter = new Formatter(){

            public String format(LogRecord rec) {
                return rec.getMessage() + "\n";
            }
        };
        private ArrayList<Handler> handList = new ArrayList();

        private OutDiffStatusListener() {
        }

        private void prepareHandlers() {
            Handler h;
            int i$;
            if (this.handList.size() > 0) {
                return;
            }
            Handler[] arr$ = LogFactory.getLogger().getParent().getHandlers();
            int len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                h = arr$[i$];
                this.handList.add(h);
            }
            arr$ = LogFactory.getLogger().getHandlers();
            len$ = arr$.length;
            for (i$ = 0; i$ < len$; ++i$) {
                h = arr$[i$];
                this.handList.add(h);
            }
        }

        private void setCustomFormatter() {
            Object[] arrHandlers = this.handList.toArray();
            for (int i = 0; i < arrHandlers.length; ++i) {
                Handler h = (Handler)arrHandlers[i];
                h.setFormatter(this.customFormatter);
            }
        }

        private void restoreSimpleFormatter() {
            Object[] arrHandlers = this.handList.toArray();
            for (int i = 0; i < arrHandlers.length; ++i) {
                Handler h = (Handler)arrHandlers[i];
                h.setFormatter(new SimpleFormatter());
            }
        }

        public void statusUpdate(String message) {
            this.prepareHandlers();
            this.setCustomFormatter();
            LogFactory.getLogger().info(message);
            this.restoreSimpleFormatter();
        }
    }
}

