/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import liquibase.database.Database;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._String;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresDatabaseSnapshot
extends SqlDatabaseSnapshot {
    public PostgresDatabaseSnapshot() {
    }

    public PostgresDatabaseSnapshot(Database database) throws JDBCException {
        super(database);
    }

    public PostgresDatabaseSnapshot(Database database, String schema) throws JDBCException {
        super(database, schema);
    }

    public PostgresDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners) throws JDBCException {
        super(database, statusListeners);
    }

    public PostgresDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners, String requestedSchema) throws JDBCException {
        super(database, statusListeners, requestedSchema);
    }

    @Override
    protected String convertFromDatabaseName(String objectName) {
        if (objectName == null) {
            return null;
        }
        return objectName.replaceAll("\"", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readUniqueConstraints(String schema) throws JDBCException, SQLException {
        this.updateListeners(new StringBuffer().append("Reading unique constraints for ").append(this.database.toString()).append(" ...").toString());
        ArrayList<UniqueConstraint> foundUC = new ArrayList<UniqueConstraint>();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            statement = this.database.getConnection().prepareStatement("select pgc.conname, pgc.conrelid, pgc.conkey, pgcl.relname from pg_constraint pgc inner join pg_class pgcl on pgcl.oid = pgc.conrelid and pgcl.relkind ='r' where contype = 'u'");
            rs = statement.executeQuery();
            while (rs.next()) {
                String constraintName = rs.getString("conname");
                int conrelid = rs.getInt("conrelid");
                Array keys = rs.getArray("conkey");
                String tableName = rs.getString("relname");
                UniqueConstraint constraintInformation = new UniqueConstraint();
                constraintInformation.setName(constraintName);
                constraintInformation.setTable((Table)this.tablesMap.get(tableName));
                this.getColumnsForUniqueConstraint(conrelid, keys, constraintInformation);
                foundUC.add(constraintInformation);
            }
            this.uniqueConstraints.addAll(foundUC);
        }
        finally {
            rs.close();
            if (statement != null) {
                statement.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getColumnsForUniqueConstraint(int conrelid, Array keys, UniqueConstraint constraint) throws SQLException {
        HashMap<Integer, String> columns_map = new HashMap<Integer, String>();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.database.getConnection().prepareStatement(new StringBuffer().append("select attname,attnum from pg_attribute where attrelid = ? and attnum in (").append(_String.replace(_String.replace(keys.toString(), "{", ""), "}", "")).append(")").toString());
            stmt.setInt(1, conrelid);
            rs = stmt.executeQuery();
            while (rs.next()) {
                columns_map.put(new Integer(rs.getInt("attnum")), rs.getString("attname"));
            }
            StringTokenizer str_token = new StringTokenizer(_String.replace(_String.replace(keys.toString(), "{", ""), "}", ""), ",");
            while (str_token.hasMoreTokens()) {
                Integer column_id = new Integer(str_token.nextToken());
                constraint.getColumns().add((String)columns_map.get(column_id));
            }
        }
        finally {
            rs.close();
            if (stmt != null) {
                stmt.close();
            }
        }
    }
}

