/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class View
implements DatabaseObject,
Comparable<View> {
    private Database database;
    private String name;
    private String schema;
    private List<Column> columns = new ArrayList<Column>();
    private String definition;

    public View(String name) {
        this.name = name;
    }

    public View() {
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        View view = (View)o;
        return this.name.equalsIgnoreCase(view.name);
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    @Override
    public int compareTo(View o) {
        return this.getName().compareTo(o.getName());
    }

    public String toString() {
        String viewStr = new StringBuffer().append(this.getName()).append(" (").toString();
        for (int i = 0; i < this.columns.size(); ++i) {
            viewStr = i > 0 ? new StringBuffer().append(viewStr).append(",").append(this.columns.get(i)).toString() : new StringBuffer().append(viewStr).append(this.columns.get(i)).toString();
        }
        viewStr = new StringBuffer().append(viewStr).append(")").toString();
        return viewStr;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((View)x0);
    }
}

